/*-------------------------------------------------------------------------
 *
 * mysql_password.h
 *		Kunlun Database MySQL protocol server side implementation.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/mysql_password.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef MYSQL_PASSWORD_INCLUDED
#define MYSQLPASSWORD_INCLUDED


#include <stddef.h>
#include <sys/types.h>

extern void mysql_make_scrambled_password_sha1(char *to, const char *password,
                                     size_t pass_len);

extern bool mysql_check_scramble(const unsigned char *reply, const char *message,
	const unsigned char *hash_stage2);
extern void mysql_get_salt_from_password(unsigned char *res, const char *password);
#endif /* MYSQLPASSWORD_INCLUDED */
