/*-------------------------------------------------------------------------
 *
 * sha2.h
 *		Kunlun Database MySQL protocol server side implementation.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/sha2.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef included_sha2_h
#define included_sha2_h

#include <openssl/evp.h>
#include <stddef.h>

#include <openssl/sha.h>

#define GEN_OPENSSL_EVP_SHA2_BRIDGE(size)                      \
  unsigned char *SHA_EVP##size(const unsigned char *input_ptr, \
                               size_t input_length,            \
                               char unsigned *output_ptr);
GEN_OPENSSL_EVP_SHA2_BRIDGE(512)
GEN_OPENSSL_EVP_SHA2_BRIDGE(384)
GEN_OPENSSL_EVP_SHA2_BRIDGE(256)
GEN_OPENSSL_EVP_SHA2_BRIDGE(224)
#undef GEN_OPENSSL_EVP_SHA2_BRIDGE

#endif /* included_sha2_h */
