#ifndef SHARDING_TOPO_H
#define SHARDING_TOPO_H

#include "postgres.h"

typedef struct ShardNodeConnId
{
	Oid shardid;
	Oid nodeid; // shardid=0 means metadata cluster.
	uint32_t connid;
} ShardNodeConnId;

typedef struct ShardConnKillReq
{
	char type; // 1: conn; 2: query
	char flags;
	uint16_t num_ents;
	// next request offset in request queue;
	// total request size in bytes for appended single request.
	uint32_t next_req_off;
	ShardNodeConnId entries[1];
} ShardConnKillReq;

extern Size ShardingTopoCheckSize(void);
extern void ShardingTopoCheckShmemInit(void);
extern bool RequestShardingTopoCheck(Oid shardid);
extern void ProcessShardingTopoReqs(void);

extern void ShardConnKillReqQShmemInit(void);
extern Size ShardConnKillReqQSize(void);
extern void reapShardConnKillReqs(void);
extern Size ShardConnKillReqSize(int nodes);
extern void appendShardConnKillReq(ShardConnKillReq*req);

extern ShardConnKillReq *makeMetaConnKillReq(char type, Oid nodeid, uint32_t connid);
extern ShardConnKillReq *makeShardConnKillReq(char type);

/* Get the pid of the topo service */
extern pid_t get_topo_service_pid(void);

extern void RequestSynchronizeMetaData(void);

/**
 * The main loop of the topology service, responsible for updating the
 * cluster topology, and handling requests to kill shard connection
 */
extern void TopoServiceMain(void);
#endif