/*-------------------------------------------------------------------------
 *
 * pg_comp_nodes.h
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * src/include/catalog/pg_comp_nodes.h
 *
 * NOTES
 *	  The Catalog.pm module reads this file and derives schema
 *	  information.
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_COMP_NODES_H
#define PG_COMP_NODES_H

#include "catalog/genbki.h"
#include "catalog/pg_comp_nodes_d.h"

CATALOG(pg_comp_nodes,12352,CompNodesRelationId) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
	Oid id;
        Oid svr_node_id;
        NameData name;
	NameData user;
        int32 port;

#ifdef CATALOG_VARLEN
	/* host address , ipv6 or ipv4, or host name/domain name, denoted by addrtype. */
	text hostaddr;
	text passwd;
	timestamptz when_created BKI_DEFAULT(0);
#endif
}
FormData_pg_comp_nodes;

typedef FormData_pg_comp_nodes* Form_pg_comp_nodes;

extern bool get_comp_node_addr(Oid id, char *addr, int addrlen, int32 *port);
extern bool get_comp_node_secret(Oid id, char **user, char **passwd);
extern List* get_all_comp_nodes(void);

extern void pg_comp_nodes_add_one(Oid nodeid,
				   Oid svr_node_id,
				   Datum hostaddr,
				   int32 port,
				   NameData *name,
				   NameData *user,
				   Datum passwd,
				   Datum create_tz);

extern void pg_comp_nodes_del_one(Oid nodeid);

extern void ShmCompNodeHashmapAllocation(void);
extern void ShmCompNodeHashmapFill(void);
extern void ShmCompNodeHashmapAdd(Oid nodeid, char *hostaddr, int32 port);
extern void ShmCompNodeHashmapDel(Oid nodeid);
extern bool ShmCompNodeHashmapLookup(Oid nodeid, char *hostaddr, int len, int32 *port);

#endif /* !pg_comp_nodes_H */
  