/*-------------------------------------------------------------------------
 *
 * execRemote.h
 *
 * Copyright (c) 2019 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 * 		src/include/executor/execRemote.h
 *
 *-------------------------------------------------------------------------
*/

#ifndef EXEC_REMOTE_H
#define EXEC_REMOTE_H

#include "postgres.h"
#include "executor/executor.h"
#include "nodes/execnodes.h"
#include "access/parallel.h"
#define REMOTE_JOIN_RELID 65535
extern TupleTableSlot *
ExecQualProjection(MaterialState *ms, TupleTableSlot *slot);

struct RemoteSetOp;
extern RemoteJoinState *ExecInitRemoteJoin(RemoteJoin *node, EState *estate, int eflags);
extern void ExecEndRemoteJoin(RemoteJoinState *node);
extern void ExecReScanRemoteJoin(RemoteJoinState *node);
extern void ExecRemoteJoinEstimate(RemoteJoinState *node, ParallelContext *pcxt);
extern void ExecRemoteJoinInitializeDSM(RemoteJoinState *node, ParallelContext *pcxt);
extern void ExecRemoteJoinReInitializeDSM(RemoteJoinState *node, ParallelContext *pcxt);
extern void ExecRemoteJoinInitializeWorker(RemoteJoinState *node,
                            ParallelWorkerContext *pwcxt);


extern RemoteSetOpState *ExecInitRemoteSetOp(struct RemoteSetOp *node, EState *estate, int eflags);
extern void ExecEndRemoteSetOp(RemoteSetOpState *node);
extern void ExecReScanRemoteSetOp(RemoteSetOpState *node);
extern void ExecRemoteSetOpEstimate(RemoteSetOpState *node, ParallelContext *pcxt);
extern void ExecRemoteSetOpInitializeDSM(RemoteSetOpState *node, ParallelContext *pcxt);
extern void ExecRemoteSetOpReInitializeDSM(RemoteSetOpState *node, ParallelContext *pcxt);
extern void ExecRemoteSetOpInitializeWorker(RemoteSetOpState *node,
                            ParallelWorkerContext *pwcxt);

extern MergeRemoteAggState *ExecInitMergeRemoteAgg(MergeRemoteAgg *node, EState *estate, int eflags);
extern void ExecEndMergeRemoteAgg(MergeRemoteAggState *node);
extern void ExecReScanMergeRemoteAgg(MergeRemoteAggState *node);
extern void ExecMergeRemoteAggEstimate(MergeRemoteAggState *node, ParallelContext *pcxt);
extern void ExecMergeRemoteAggInitializeDSM(MergeRemoteAggState *node, ParallelContext *pcxt);
extern void ExecMergeRemoteAggReInitializeDSM(MergeRemoteAggState *node, ParallelContext *pcxt);
extern void ExecMergeRemoteAggInitializeWorker(MergeRemoteAggState *node,
                            ParallelWorkerContext *pwcxt);
#endif // !EXEC_REMOTE_H
