/*-------------------------------------------------------------------------
 *
 * print.h
 *	  definitions for nodes/print.c
 *
 *
 * Portions Copyright (c) 1996-2018, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/nodes/print.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef PRINT_H
#define PRINT_H

#include "executor/tuptable.h"
#include "lib/stringinfo.h"
#include "nodes/params.h"

#define nodeDisplay(x)		pprint(x)

/*
 * Print the PlaceHolderVar with newly generated alias if it is just a reference
 */
struct PlaceHolderVar;
typedef struct PhvAlias
{
	struct PlaceHolderVar *phv;
	char *alias;
} PhvAlias;

typedef struct VarAlias
{
	Var *var;
	char *alias;
	int levelno;
} VarAlias;

typedef struct RemotePrintExprContext
{
	EState *estate;
	const List *rtable;
	/*
	  All Params' 'paramid' indexes refer to this array.
	*/
	ParamExecData *rpec_param_exec_vals;
	ParamListInfo rpec_param_list_info;

	/* True if print param/unsafe func as '?' */
	bool make_prepare_stmt;
	bool parameterized_const_expr;
	/* Information abort the param (i.e. position in sql)*/
	List *params;
	List *params_location;
	/* Information abort the unsafe function */
	List *unsafe_func_placeholder;

	/*
	  If true, param node will be executed if it does not refer to
	  external parameters, otherwise it will be treated unsupported
	*/
	bool exec_param_quals;

	/* Placeholder vars that assigned aliases */
	List *phv_alias;

	/* Vars that assigned aliases */
	List *var_alias;

	/* Print var with relname, i.e. t1.a */
	bool full_varname;

	/* Column name of excluded table in on conflict clause */
	List *excluded_table_columns;

	/* Print nextval with consumed sequence */
	bool consume_sequence;

	/* Print var as user variable, i.e. @a */
	Index printas_uvars_rti;
	Bitmapset *printas_uvars;

	/* The CoerceToDomainValue */
	Expr *domain_value;
	bool domain_value_used;

	/* Do not print expr to mysql sql, just verify */
	bool noprint;
} RemotePrintExprContext;

extern void InitRemotePrintExprContext(RemotePrintExprContext *rpec, List*rtable);
extern void ResetRemotePrintExprContext(RemotePrintExprContext *rpec, bool b);
extern void print(const void *obj);
extern void pprint(const void *obj);
extern void elog_node_display(int lev, const char *title,
				  const void *obj, bool pretty);
extern char *format_node_dump(const char *dump);
extern char *pretty_format_node_dump(const char *dump);
extern void print_rt(const List *rtable);
extern void print_expr(const Node *expr, const List *rtable);
extern void print_pathkeys(const List *pathkeys, const List *rtable);
extern void print_tl(const List *tlist, const List *rtable);
extern void print_slot(TupleTableSlot *slot);

extern bool is_mysql_proc(Oid funcoid);
extern bool is_mysql_operator(Oid opoid);
extern bool is_expr_printable(const Expr *expr, RemotePrintExprContext *rpec);
extern int snprint_expr(StringInfo buf, const Expr *expr, RemotePrintExprContext *rpec);
extern int snprint_collation_id(StringInfo str, Oid collid, RemotePrintExprContext *rpec);
extern int snprint_collation(StringInfo str, const Expr *expr, RemotePrintExprContext *rpec);
extern Oid my_output_funcoid(Oid typid, bool *typIsVarlena);
extern bool can_bind_param_expr(EState *estate, List *params);
#endif							/* PRINT_H */
