/*-------------------------------------------------------------------------
 *
 * remotenodes.h
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 * 		src/include/nodes/remotenodes.h
 *
 *-------------------------------------------------------------------------
*/
#ifndef REMOTE_NODES_H
#define REMOTE_NODES_H

#include "nodes/nodes.h"
#include "lib/stringinfo.h"
//#include "nodes/execnodes.h"
struct EState;
struct AppendState;
struct SortState;
struct Sort;
struct MergeAppendState;
struct LimitState;
struct UniqueState;
struct PlannedStmt;

extern bool expression_tree_modifier(Node **node,
				     bool (*handler)(),
				     bool (*walker)(),
				     void *context);

extern bool is_mysql_agg_func(Aggref *aggref, bool *pdistinct, bool *porderby, bool *pmyserial);

extern char *get_mysql_agg_name(Aggref *aggref, char *buff);

extern bool is_mysql_agg_funcid(Oid funcid, List *args);

#endif // !REMOTE_NODES_H
