#ifndef SHARDING_VNODE_H
#define SHARDING_VNODE_H

#include "postgres.h"

/**
 * @brief Check if the given {shardid, node} pair is a virtual node
 */
extern bool IsSnapshotNode(Oid shardid, Oid node);

/**
 * @brief Get the shard id of the coresponding snapshot node
 */
extern Oid GetSnapshotShard(Oid snapshot_node);

/**
 * @brief create a virtual node id from the given shard/node id.
 *
 * The created virtual node can be passed to GetAsyncStmtInfo(...) to create
 * a new read-only channel  which can execute query parallelly with the original channel.
 */
extern bool GetSnapshotNode(Oid shard, Oid node, bool prefer_vnode, Oid *snapshot_node);

/**
 * @brief Get the original node id from the virtual shard/node id.
 */
extern bool FromSnapshotNode(Oid snapshot_node, Oid *shard, Oid *node);

/**
 * @brief Delete unused virtual node from hashmap
 */
extern void DeleteSnapshotNode(Oid snapshot_node);

/**
 * @brief Get the number of virtual nodes of the given shard-node pair
 */
extern int NumActiveSnapshotNodes(Oid shard, Oid node);

/**
 * @brief Reset all used vnode into 'unused' state at the end of query
 */
extern void ResetAllSnapshotNode(bool stmt);

#endif