/*-------------------------------------------------------------------------
 *
 * pg_mysql_charset_mapping.h
 *	  mapping of PostgreSQL and MySQL system character sets.
 *
 *
 * Copyright (c) 2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * src/include/catalog/pg_mysql_charset_mapping.h
 *
 * NOTES
 *	  The Catalog.pm module reads this file and derives schema
 *	  information.
 *
 *-------------------------------------------------------------------------
 */

#ifndef PG_MYSQL_CHARSET_MAPPING_H
#define PG_MYSQL_CHARSET_MAPPING_H

#include "catalog/genbki.h"
#include "catalog/pg_mysql_charset_mapping_d.h"

/*
  Map a pg's charset to a mysql charset and its default collation.
 * */
CATALOG(pg_mysql_charset_mapping,12355,PgMySQLCharsetMappingId) BKI_SHARED_RELATION BKI_WITHOUT_OIDS
{
  int32 pg_charset_enc;
  int32 mysql_charset_num; /*comes from mysql ctype*.cc */
  bool deduced; /* we deduce a few entries from info from various docs and internet */
  int16 mbmaxlen; /* 0: undefined, not specified; positive: max NO. of bytes any char in the charset can take. */
  NameData mysql_csname; /* mysql charset */
  NameData mysql_collname; /* mysql collation */
}
FormData_pg_mysql_charset_mapping;

typedef FormData_pg_mysql_charset_mapping*Form_pg_mysql_charset_mapping;

#endif /* !PG_MYSQL_CHARSET_MAPPING_H */
