#ifndef EXTRA_COMMAND_H
#define EXTRA_COMMAND_H

#include "nodes/parsenodes.h"

struct _DestReceiver;

extern void ExecKillStmt(KillStmt *stmt);
extern void ExecShowSchemas(char *pattern, Node *whereClause, struct _DestReceiver *dest);
extern void ExecShowDatabases(char *pattern, Node *whereClause, struct _DestReceiver *dest);
extern void ExecShowTables(bool full, char *pattern, char *schema, Node *whereClause, struct _DestReceiver *dest);
extern void ExecShowCreateTable(ShowCreateTableStmt *stmt, struct _DestReceiver *dest);
extern void ExecShowProcessList(bool local,  Node *whereClause, struct _DestReceiver *dest);
extern void ExecSendShardStmt(char *shard, char *query, struct _DestReceiver *dest);
extern void ExecSendShardStmtInternal(Oid shardid, const char *query, char *name_pattern, Expr *whereClause, struct _DestReceiver *dest, bool is_select_vars);
extern void ExecShowTableStatus(char *schema, char *pattern, Node *whereClause, struct _DestReceiver *dest);
extern void ExecOptimizeStmt(OptimizeStmt *stmt);
extern void ExecShowMemory(struct _DestReceiver *dest);

#endif
