#ifndef RWCONFLICT_CHECK_H
#define RWCONFLICT_CHECK_H
#include "postgres.h"

typedef struct RemoteRWCheckContext
{
	int nrels;
	bool modified;
	CommandId cid;
	void* owner;
	Oid relids[FLEXIBLE_ARRAY_MEMBER];
} RemoteRWCheckContext;

/**
 * @brief 事务结束或回滚时，清理用于检查事务中读写冲突的哈希表 
 */
extern void AtEOXact_RelationRWCheck(void);

/**
 * @brief 记录对给定relation的读写操作，并检查是否存在读写冲突。如果冲突则抛出异常
 */
extern void RemoteRelationRWCheck(Oid relid, bool modified, CommandId ctid, void *owner);

/**
 * @brief 同RemoteRelationRWCheck，但冲突时返回true，而不是抛出异常
 */
extern bool RemoteRelationRWCheckSilent(RemoteRWCheckContext *context);

#endif