#ifndef REPLICA_READ_H
#define REPLICA_READ_H

#include "postgres.h"

#include "nodes/execnodes.h"

/**
 * @brief Check if current statement can do replica read 
 */
extern bool can_stmt_read_replicas(EState *estate);

/**
 * @brief Choose a replica of given shard for replica read
 */
extern Oid choose_replica(Oid shardid);

/**
 * @brief Choose a replica of given shard for auto analyze
 */
extern Oid choose_replica_for_analyze(Oid shardid);

#endif