#!/bin/bash

PORT=$1
PSTACK_RLT_ROOT=$2

# 0. validate the parameters
if [ $# -ne 2 ]; then
  echo "Usage: bash $0 PORT OUTPUT_PATH"
  exit 1
fi

# 1. find postmaster process pid 
POSTMASTER=`ps -ef | grep postgres | grep '\-D' | grep ${PORT} | awk '{print $2}'`

# 2. find all child process pid
CHILDS=`cat /proc/${POSTMASTER}/task/${POSTMASTER}/children`

# 3. prepare the output directory
PSTACK_RLT_ROOT_ABS=`realpath ${PSTACK_RLT_ROOT}`

  # 3.1 validate the output path
TMP=`stat ${PSTACK_RLT_ROOT_ABS} 2>&1`
if [ $? -eq 1 ]; then
  echo "${TMP}"
  exit 1
fi

  # 3.2 make the output dir
SUFFIX=`date +'%s'`
DIR_NAME="info_pstack_${PORT}_${SUFFIX}"
PSTACK_RLT_FULL_PATH="${PSTACK_RLT_ROOT_ABS}/${DIR_NAME}"
mkdir ${PSTACK_RLT_FULL_PATH}

# 4. exec pstack and save result
for pid in ${CHILDS}
do
  #echo ${pid}
  pstack ${pid} > ${PSTACK_RLT_FULL_PATH}/${pid}.txt &
done
wait

# 5. compact the result
for file in `ls ${PSTACK_RLT_FULL_PATH}`
do
  echo "Thread ${file}" >> ${PSTACK_RLT_FULL_PATH}/compact.txt
  cat ${PSTACK_RLT_FULL_PATH}/${file} >> ${PSTACK_RLT_FULL_PATH}/compact.txt
done 

pt-pmp ${PSTACK_RLT_FULL_PATH}/compact.txt > ${PSTACK_RLT_FULL_PATH}/pt-pmp.txt
echo "Done!"

