#!/bin/env python2
import argparse
import os
import sys
import getpass
import re
import time
import shutil

def rollback_installation(args):
    error_count = 0
    workpath = "{prefix}/{pt}/{prgname}".format(
        prefix=os.path.abspath(args.install_prefix), pt=str(args.pg_protocal_port), prgname=str(args.prog_name)
    )
    bin_path = "{wp}/bin".format(wp=workpath)

    datadir = os.path.abspath(args.datadir_prefix) + "/" + str(args.pg_protocal_port)

    # 1. Stop postgres instance if already running by invoking stop_mysql.sh
    cmd_stop_pg = "cd {dp};./pg_ctl -D {d_dir} stop".format(dp=bin_path,d_dir=str(datadir))
    try:
        os.system(cmd_stop_pg)
    except OSError as err:
        sys.stderr.write("Stop Postgres instance failed: {}".format(str(err)))
        error_count = error_count +1

    # 2. remove the related directory
    try:
        # 1.1 remove the Postgres binary residential directory
        runing_dir = os.path.abspath(args.install_prefix) + "/" + str(args.pg_protocal_port)
        shutil.rmtree(runing_dir,ignore_errors=True)

        # 1.2 remove the Postgres data residential directory
        data_dir = os.path.abspath(args.datadir_prefix) + "/" + str(args.pg_protocal_port)
        shutil.rmtree(data_dir,ignore_errors=True)

    except OSError as err:
        sys.stderr.write("Remove the Instance data and log failed: {}".format(str(err)))
        error_count = error_count+1
    
    if error_count > 0:
      return False
    
    return True

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Install computing node")
    parser.add_argument('--user',type=str,help="The user for connect postgresql process",required=True)
    parser.add_argument('--password',type=str,help="The password for user connect Postgres",required=True)
    parser.add_argument('--bind_address',type=str,help="The binding ip address of Postgres",required=True)
    parser.add_argument('--pg_protocal_port',type=int,help="The port listen in Postgresql protocal",required=True)
    parser.add_argument('--mysql_protocal_port',type=int,help="The port listen in MySQL Protocal",required=False)
    parser.add_argument('--compute_node_id',type=int,help="The compute node id in the cluster",required=True)
    parser.add_argument('--datadir_prefix',type=str,help="Postgres data dir prefix",required=True)
    parser.add_argument('--install_prefix',type=str,help="Postgres install prefix",required=True)
    parser.add_argument('--prog_name',type=str,help="Postgres pkg name",required=True)
    parser.add_argument('--valgrind',type=bool,help="Start Postgresql with valgrind or not",required=False,default=False)
    args= parser.parse_args()

    ret = rollback_installation(args)
    if ret == False:
        exit(1)

    exit(0)
