#!/bin/bash

cnfpath=`realpath ../conf/node_mgr.cnf`
source ./extra.env

num=`ps -ef | grep ${cnfpath} | grep -v grep | grep -v vim | wc -l`
[ $num -gt 0 ] && {
        echo `pwd`"node_mgr is running, so quit to start again" 
        exit 0
}

if test "$USE_VALGRIND" = ""; then
	./node_mgr ${cnfpath} >../log/std.log 2>&1
else
	valgrind --leak-check=full --undef-value-errors=no ./node_mgr ${cnfpath} >../log/std.log 2>&1
fi

# sleep 5 seconds to let the process appear in ps command, for busy machines.
sleep 5

ps -ef | grep ${cnfpath} | grep -v grep
