# 昆仑分布式数据库简介

昆仑分布式数据库集群（下文简称昆仑或者昆仑系统）是一个分布式关系数据库管理系统，面向TB和PB级别海量数据处理，以高吞吐量和低延时处理海量数据高并发读写请求。它提供健壮的事务ACID保障，高效易用的分布式查询处理，高可扩展性，高可用性和透明的分库分表数据处理功能，业务层和终端用户无感知的水平扩展能力，是典型的 NewSQL分布式数据库系统。应用软件开发者按照使用单节点关系数据库相同的方法使用昆仑数据库，就可以得到所有上述NewSQL数据库的优点，完全不需要考虑数据的分区方式等存储细节。这样，应用开发者就可以非常快速滴开发健壮可靠的，高可用和高可扩展的信息系统，来处理PB级海量数据。所有的海量数据管理的挑战和困难都由昆仑系统来解决，从而大大降低了开发分布式系统的时间成本和资金成本和技术难度，并且全面提升其产品质量，大大加快应用开发和变更过程中的上线进度。

## 架构

一个昆仑分布式数据库集群有3类组件构成：一个或者多个计算节点，一个或者多个存储shard以及一个元数据集群。

本软件是昆仑数据库的计算节点，基于PostgreSQL-11.5开发。为了实现自动的DDL同步及复制以及分布式事务，分布式查询处理等高级功能，我们大量地修改了PostgreSQL源代码，而不是直接使用其FDW接口。我们的代码保持了很好的模块化，方便将来可以继续跟随PostgreSQL版本更新。

kunlun-storage是昆仑数据库的存储节点，它是我们基于percona-server-8.0深度优化开发的MySQL分支。用户必须使用kunlun-storage软件组建昆仑数据库的存储集群和元数据集群，因为昆仑数据库集群需要的关键功能只存在于kunlun-storage中，并且它还包含了社区版MySQL-8.0 XA事务处理的所有容灾缺陷的修复；最后，kunlun-storage在XA事务处理方面比社区版mysql有大幅性能优化。

计算节点使用PostgreSQL协议（后续会支持MySQL客户端协议）接收和验证用户的连接请求，验证通过后，就接收和处理连接上发来的查询并返回结果给客户端。用户可以根据工作负载来增减计算节点，每个计算节点彼此平等和独立，没有依赖关系，都可以处理用户连接和读写请求。计算节点含有每个数据表以及其他数据库对象的元数据，但是用户数据存储在存储shard中。执行一个SQL时，计算节点解析该语句，然后对它做分布式查询优化，然后通过与后端存储shard做交互来完成分布式查询执行。交互的方法就是根据SQL语句的需要和数据在后端shard的分布信息，为相关的后端存储shard生成SQL语句。如果执行的SQL语句是 SELECT 或者 INSERT/DELETE/UPDATE...RETURNING 而不是简单的 INSERT/DELETE/UPDATE, 那么计算节点会并发地发送语句然后接收结果，最后合并处理所有后端存储shard返回的结果，形成最终的查询结果，返回给客户端。

每个存储shard 存储着一部分用户表或者表分区，每个shard的数据子集没有交集；每个存储shard是一个MySQL binlog复制集群，通过标准的MySQL MGR single master 模式或者基于传统的row based binlog复制的强同步机制来实现高可用性。一个shard的主节点接受来自计算节点的读写请求，执行请求并返回结果给计算节点；启用了备机读功能时，shard的备节点可以接收和处理来自计算节点的只读请求。用户可以根据数据量的增加和减少来增加和较少存储shard，数据会自动均匀分散到所有shard上面，从而达到自动和透明的高可扩展性。

元数据集群也是一个MySQL binlog复制集群，存储着一个昆仑数据库集群的元数据。多个数据库集群可以共用同一个元数据集群。

最后，昆仑数据库还有一个cluster_mgr程序，它负责维护正确的集群和节点状态，占用资源极少。

## 特点和优势

昆仑分布式数据库的主要设计目标是高可扩展性，高可用性和完备的容灾能力，高性能，分布式事务ACID保障，和透明易用的分布式查询处理。 

### 高可扩展性
昆仑系统高可扩展，不仅垂直可扩展（scale up），而且水平可扩展（scale out）：用户可以通过增加计算节点来提升查询处理性能，每个计算节点都可以服务读写请求；用户也可以增加更多的存储shard来存储更多的数据并获得更大的查询处理和事务处理能力。数据会自动被平滑地用户无感知的方式分散到新增的存储集群中，确保所有集群承担近乎平均的存储负载。

### 高可用性
昆仑分布式数据库集群具备高可用性，部分节点宕机不会导致昆仑数据库集群不可用。对于一个拥有2N+1 个MySQL节点的存储shard或者元数据集群来说，这个shard可以抵抗N个节点同时宕机并持续提供服务；计算节点宕机并不会导致昆仑系统整体不可用，只要系统还有计算节点进程存在，那么昆仑系统整体仍可以处理用户请求。一个计算节点宕机不会影响同一个昆仑集群内其他计算节点正常工作。宕机的计算节点当时正在处理的事务会自动回滚，用户连接会断开，用户数据和系统元数据始终保持一致。

### 分布式事务处理和分布式查询处理
昆仑系统的分布式查询处理的目标是让用户在写查询语句时不需要考虑他的数据是如何在存储集群分布的。这部分得益于分布式事务处理功能，部分得益于分布式查询处理功能。有了这两大类功能，用户就可以像使用单机MySQL或者PostgreSQL那样写SQL查询语句，不需要知道其SQL语句所读写的任何部分的数据是如何分布在哪几个存储shard 这类问题，也就是说应用开发者完全不需要直接使用或者知道‘分布式事务处理’或者‘分布式查询处理’这样的概念，所有这些强大的功能都是在后台默默为用户服务的，给用户带来简单的使用体验。

昆仑系统基于久经考验的两阶段提交协议（2PC）来自动做分布式事务处理，事务提交时候根据需要做两阶段提交或者一阶段提交。只要存储shard是 ‘XA resilient’ 的，那么分布式事务就有ACID保障。 不过，目前MySQL官方发布的社区版本没有 ‘XA resilient’ 的，它们都有一些无法良好支持的XA事务处理特性。 [这个文档](https://dev.MySQL.com/doc/refman/8.0/en/xa-restrictions.html) 和 [这个文档](https://dev.MySQL.com/doc/refman/5.7/en/xa-restrictions.html)含有所有官方MySQL版本不支持的XA事务处理功能。 当用户使用官方社区版本时，如果一个或者多个主/备节点宕机或者binlog复制发生中断，或者主备连接断开，那么有可能一些分布式事务会部分丢失已提交的改动或者在多个存储shard的事务分支的提交状态不同（部分提交，部分回滚），或者binlog 复制无法恢复工作等问题。
所以用户必须使用kunlun-percona-mysql-8.0，它填补了所有官方MySQL版本的XA事务处理的空白，是完全 ‘XA resilient’ 的。

昆仑系统的分布式查询处理被设计和实现成为PostgreSQL的查询处理流程的有机组成部分。查询优化会考虑到数据在存储shard和计算节点之间的网络传输代价，以及在计算节点内部的合并处理来自存储shard的子结果的额外的开销。在此基础之上，试图最小化整体的查询处理开销。

### 自动DDL
昆仑分布式数据库集群支持自动DDL，也即是说，在一个计算节点执行一个DDL时候，它会自动在集群所有计算节点生效并且相关的存储集群上面需要为此DDL执行的DDL语句也会作为整体DDL语句的一部分被自动执行。并且这样的自动DDL是可以容灾的，DDL执行期间集群任何计算节点或者存储节点因为任何原因退出或者宕机，集群的用户数据和元数据的一致性和完整性可以得到保障。可以看出，这个功能可以大大滴把DBA和运维人员从重复和易错的繁重的运维劳动中解放出来，大大提升他们的工作效率。

例如，我们有两个连接conn1和conn2,分别连接着同一个集群的两个计算节点CN1和CN2,现在我们在conn1中执行create table语句创建表tx，该语句执行期间，tx的会在CN1的catalog中被定义，tx在存储shard上面的表会在该DDL语句执行期间被妥善地在自动选定（会有多种策略）的shard上面创建好。该DDL语句执行成功后，立刻（可配置的若干秒）在CN2以及本集群所有计算节点上面我们就可以使用表tx，对它做增删改查等操作. 我把这个功能叫做‘自动DDL’。
所有涉及到存储shard的DDL语句目前都已经支持自动DDL，包括create/drop/alter table/partition/index/database/schema/sequence/materialized view。对于其他的DDL，用户在任何一个计算节点执行该语句，本集群所有计算节点上面都会生效。


## 其他
为了方便用户，我们创建了昆仑数据库各模块的docker镜像，同时提供了企业版的二进制程序，可访问 downloads.zettadb.com来下载。下载的压缩包里面有使用手册。


## 联络和资源

昆仑系统目前已发布的Kunlun-0.8.3版本是一个 POC ready的版本，不是生产系统可用的版本。当前版本虽然已经具备了大量功能（各发布版本的功能集合详见ReleaseNotes.md)，我们还在积极开发下一个阶段的功能，欢迎大家试用当前版本，有任何疑问可以加入 昆仑数据库讨论群咨询和讨论（QQ群，号码：336525623）或者访问bugs.zettadb.com 报告bug以及查看每个bug的详细信息，每一个报告了bug的朋友我们都会在contributors文件中列出以表达感谢。

昆仑分布式数据库已经完全开源，欢迎访问 https://github.com/zettadb 或者 https://gitee.com/zettadb/ 获取昆仑数据库的各模块的源代码并且为Kunlun数据库项目 加星来给予我们鼓励。


