/*-------------------------------------------------------------------------
 *
 * print.h
 *	  definitions for nodes/print.c
 *
 *
 * Portions Copyright (c) 1996-2018, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/nodes/print.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef PRINT_H
#define PRINT_H

#include "executor/tuptable.h"
#include "lib/stringinfo.h"
#include "nodes/params.h"

#define nodeDisplay(x)		pprint(x)
typedef struct RemotePrintExprContext
{
	const List *rtable;
	/*
	  All Params' 'paramid' indexes refer to this array.
	*/
	ParamExecData *rpec_param_exec_vals;
	ParamListInfo rpec_param_list_info;
	/*
	  If true, Param node will be treated as unsupported, otherwise
	  the qual containing the param will be serialized.
	*/
	bool ignore_param_quals;
	/*
	  True when currently traversing agg count() 's arg nodes.
	*/
	bool is_agg_count_args;
	bool has_aggref;
	int skip_n; // skip first N elements
	/*
	  How many values is the target expr serialized to. 1 for most exprs,
	  except a few like RowExpr.
	*/
	int num_vals;
} RemotePrintExprContext;

extern void InitRemotePrintExprContext(RemotePrintExprContext *rpec, List*rtable);
extern void ResetRemotePrintExprContext(RemotePrintExprContext *rpec, bool b);
extern void print(const void *obj);
extern void pprint(const void *obj);
extern void elog_node_display(int lev, const char *title,
				  const void *obj, bool pretty);
extern char *format_node_dump(const char *dump);
extern char *pretty_format_node_dump(const char *dump);
extern void print_rt(const List *rtable);
extern void print_expr(const Node *expr, const List *rtable);
extern void print_pathkeys(const List *pathkeys, const List *rtable);
extern void print_tl(const List *tlist, const List *rtable);
extern void print_slot(TupleTableSlot *slot);
extern int snprint_expr(StringInfo buf, const Expr *expr, RemotePrintExprContext *rpec);
#endif							/* PRINT_H */
