/*-------------------------------------------------------------------------
 *
 * remote_path.h
 *
 * Copyright (c) 2019-2021 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 * 		src/include/optimizer/remote_path.h
 *
 *-------------------------------------------------------------------------
*/
#ifndef REMOTE_PATH_H
#define REMOTE_PATH_H


extern bool can_do_remote_join(PlannerInfo *root, RelOptInfo *rel1, RelOptInfo *rel2,
	JoinType jt, List *restrictionList);
extern void add_remote_path_to_joinrel(PlannerInfo *root,
                     RelOptInfo *joinrel,
                     RelOptInfo *outerrel,
                     RelOptInfo *innerrel,
                     JoinType jointype,
                     SpecialJoinInfo *sjinfo,
                     List *restrictlist);
extern bool can_push_down_restrictions(PlannerInfo *root, List *restrictionList);
extern RemoteAggPath *
create_remote_agg_path(PlannerInfo *root, RelOptInfo *input_rel,
					   Path *subpath, RelOptInfo *grouped_rel, List *havingQual,
					   List *groupClause, double numgroups, RemoteAggInfo *rai);
extern bool can_do_remoteagg(PlannerInfo *root, RelOptInfo *input_rel,
					  RelOptInfo *grouped_rel, List *havingQual, RemoteAggInfo *rai);
extern RemoteAggRef *fix_remote_agg_tlist_grouping(PlannerInfo *root,
	List *remote_plans, List *agg_tlist, RemoteAggInfo *rai);
#endif // !REMOTE_PATH_H
