#!/bin/bash

cnfpath=`realpath ../conf/kunlun_cdc.cnf`
libpath=`realpath ../lib`
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:${libpath}
num=`ps -ef | grep ${cnfpath} | grep -v grep | grep -v vim | wc -l`
[ $num -gt 0 ] && {
        echo `pwd`"/kunlun_cdc is running, so quit to start again" 
        exit 0
}

ulimit -c unlimited
export LD_PRELOAD=${libpath}/libjemalloc.so
./kunlun_cdc ${cnfpath} >> ../log/std_paxos.log 2>&1

ps -ef | grep ${cnfpath} | grep -v grep
