/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.TupleDesc;

public class Tuple {
    private final State m_state;

    Tuple(DualState.Key cookie, long resourceOwner, long pointer) {
        this.m_state = new State(cookie, this, resourceOwner, pointer);
    }

    public final long getNativePointer() throws SQLException {
        return this.m_state.getHeapTuplePtr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(TupleDesc tupleDesc, int index, Class<?> type) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return Tuple._getObject(this.getNativePointer(), tupleDesc.getNativePointer(), index, type);
        }
    }

    private static native Object _getObject(long var0, long var2, int var4, Class<?> var5) throws SQLException;

    private static class State
    extends DualState.SingleHeapFreeTuple<Tuple> {
        private State(DualState.Key cookie, Tuple t, long ro, long ht) {
            super(cookie, t, ro, ht);
        }

        private long getHeapTuplePtr() throws SQLException {
            this.pin();
            try {
                long l = this.guardedLong();
                return l;
            }
            finally {
                this.unpin();
            }
        }
    }
}

