/*-------------------------------------------------------------------------
 *
 * mysql_com_server.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		Compression related structs.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/mysql_com_server.h
 *
 *-------------------------------------------------------------------------
 */

#ifndef _mysql_com_server_h
#define _mysql_com_server_h

#include <stddef.h>

#include "mysql_compress.h"

typedef void (*before_header_callback_fn)(CommBuffer *net, void *user_data,
                                          size_t count);

typedef void (*after_header_callback_fn)(CommBuffer *net, void *user_data,
                                         size_t count, bool rc);

/**
  This structure holds the negotiated compression algorithm and level
  between client and server.
*/
typedef struct compression_attributes {
  char compress_algorithm[COMPRESSION_ALGORITHM_NAME_LENGTH_MAX];
  unsigned int compress_level;
  bool compression_optional;
}compression_attributes ;

extern void init_compression_attributes(compression_attributes *ca);

typedef struct CompressionCtx {
  before_header_callback_fn m_before_header;
  after_header_callback_fn m_after_header;
  void *m_user_data;
  struct compression_attributes compression;
  mysql_compress_context compress_ctx;
  /** Max buffer length, without headers, received during the last
  global.net_buffer_shrink_interval. */
  unsigned long max_interval_packet;
  unsigned long long net_buffer_shrink_time;
} CompressionCtx;

extern CompressionCtx *InitCompressionCtx(void);
#endif
