/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;

public abstract class ByteBufferInputStream
extends InputStream {
    protected final Object m_lock;
    protected boolean m_open;

    protected ByteBufferInputStream() {
        this.m_lock = this;
        this.m_open = true;
    }

    protected ByteBufferInputStream(Object lock) {
        this.m_lock = lock;
        this.m_open = true;
    }

    protected void pin() throws IOException {
    }

    protected void unpin() {
    }

    protected abstract ByteBuffer buffer() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        int n;
        this.pin();
        try {
            Object object = this.m_lock;
            synchronized (object) {
                ByteBuffer src = this.buffer();
                if (0 < src.remaining()) {
                    byte by = src.get();
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.unpin();
                    return by;
                }
                n = -1;
            }
        }
        catch (Throwable throwable) {
            this.unpin();
            throw throwable;
        }
        this.unpin();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        this.pin();
        try {
            Object object = this.m_lock;
            synchronized (object) {
                ByteBuffer src = this.buffer();
                int has = src.remaining();
                if (len > has) {
                    if (0 == has) {
                        int n2 = -1;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 6, 7] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                        this.unpin();
                        return n2;
                    }
                    len = has;
                }
                src.get(b, off, len);
            }
        }
        catch (Throwable throwable) {
            this.unpin();
            throw throwable;
        }
        {
            n = len;
        }
        this.unpin();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        this.pin();
        try {
            Object object = this.m_lock;
            synchronized (object) {
                ByteBuffer src = this.buffer();
                int has = src.remaining();
                if (n > (long)has) {
                    n = has;
                }
                src.position(src.position() + (int)n);
                long l = n;
                return l;
            }
        }
        finally {
            this.unpin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        this.pin();
        try {
            Object object = this.m_lock;
            synchronized (object) {
                int n = this.buffer().remaining();
                return n;
            }
        }
        finally {
            this.unpin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_open) {
                return;
            }
            this.m_open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readlimit) {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_open) {
                return;
            }
            boolean gotPin = false;
            try {
                this.pin();
                gotPin = true;
                this.buffer().mark();
            }
            catch (IOException iOException) {
            }
            finally {
                if (gotPin) {
                    this.unpin();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_open) {
                return;
            }
            this.pin();
            try {
                this.buffer().reset();
            }
            catch (InvalidMarkException e) {
                throw new IOException("reset attempted when mark not set");
            }
            finally {
                this.unpin();
            }
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

