/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ByteBufferInputStream;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.MarkableSequenceInputStream;

public interface VarlenaWrapper
extends Closeable {
    public long adopt(DualState.Key var1) throws SQLException;

    public String toString(Object var1);

    public static abstract class Verifier
    implements Callable<Void> {
        private final BlockingQueue<InputStream> m_queue;
        private final CountDownLatch m_latch;
        private volatile Future<Void> m_future;

        private Future<Void> future() throws SQLException {
            Future<Void> f = this.m_future;
            if (null != f) {
                return f;
            }
            try {
                this.m_latch.await();
            }
            catch (InterruptedException e) {
                throw new SQLException("Waiting thread interrupted", e);
            }
            return this.m_future;
        }

        private Verifier(BlockingQueue<InputStream> queue, CountDownLatch latch) {
            this.m_queue = queue;
            this.m_latch = latch;
        }

        private Verifier() {
            this(new LinkedBlockingQueue<InputStream>(), new CountDownLatch(1));
        }

        protected void verify(InputStream is) throws Exception {
            do {
                is.skip(Long.MAX_VALUE);
            } while (-1 != is.read());
        }

        @Override
        public final Void call() throws Exception {
            MarkableSequenceInputStream is = null;
            try {
                is = new MarkableSequenceInputStream(this.m_queue);
                this.verify(is);
            }
            finally {
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Verifier schedule() {
            CountDownLatch countDownLatch = this.m_latch;
            synchronized (countDownLatch) {
                if (1L == this.m_latch.getCount()) {
                    this.m_future = LazyExecutorService.INSTANCE.submit(this);
                    this.m_latch.countDown();
                }
            }
            return this;
        }

        public void update(InputStream is) throws SQLException {
            Future<Void> f = this.future();
            if (f.isDone()) {
                this.finish();
                throw new SQLException("Verifier finished prematurely");
            }
            try {
                this.m_queue.put(is);
            }
            catch (InterruptedException e) {
                f.cancel(true);
                throw (CancellationException)new CancellationException("Waiting thread interrupted").initCause(e);
            }
        }

        public void update(Output.State state, ByteBuffer bb) throws SQLException {
            bb.flip();
            this.update(new BufferWrapper(state, bb));
        }

        public void cancel() throws SQLException {
            Future<Void> f = this.future();
            f.cancel(true);
        }

        public void finish() throws SQLException {
            Future<Void> f = this.future();
            try {
                f.get();
            }
            catch (InterruptedException inte) {
                f.cancel(true);
                throw (CancellationException)new CancellationException("Waiting thread interrupted").initCause(inte);
            }
            catch (ExecutionException exce) {
                Throwable t = exce.getCause();
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new SQLException("Exception verifying variable-length data: " + exce.getMessage(), "XX000", exce);
            }
            if (!this.m_queue.isEmpty()) {
                throw new SQLException("Verifier finished prematurely");
            }
        }

        static class BufferWrapper
        extends ByteBufferInputStream {
            private ByteBuffer m_buf;
            private Output.State m_nativeState;

            BufferWrapper(Output.State state, ByteBuffer buf) {
                this.m_nativeState = state;
                this.m_buf = buf;
            }

            @Override
            protected void pin() throws IOException {
                try {
                    this.m_nativeState.pin();
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            protected void unpin() {
                this.m_nativeState.unpin();
            }

            @Override
            protected ByteBuffer buffer() throws IOException {
                if (!this.m_open) {
                    throw new IOException("I/O operation on closed VarlenaWrapper.Verifier");
                }
                return this.m_buf;
            }
        }

        static class LazyExecutorService {
            static final ExecutorService INSTANCE;

            LazyExecutorService() {
            }

            static {
                final ThreadFactory dflttf = Executors.defaultThreadFactory();
                ThreadFactory daemtf = new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = dflttf.newThread(r);
                        if (null != t) {
                            t.setDaemon(true);
                            t.setName("varlenaVerify-" + t.getName().substring(5));
                        }
                        return t;
                    }
                };
                INSTANCE = Executors.newCachedThreadPool(daemtf);
            }
        }

        public static class Base
        extends Verifier {
            protected Base() {
            }

            @Override
            public final Verifier schedule() {
                return super.schedule();
            }

            @Override
            public final void update(InputStream is) throws SQLException {
                super.update(is);
            }

            @Override
            public final void update(Output.State state, ByteBuffer bb) throws SQLException {
                super.update(state, bb);
            }

            @Override
            public final void finish() throws SQLException {
                super.finish();
            }

            @Override
            public final void cancel() throws SQLException {
                super.cancel();
            }
        }

        public static final class NoOp
        extends Verifier {
            public static final Verifier INSTANCE = new NoOp();

            private NoOp() {
                super(null, null);
            }

            @Override
            public Verifier schedule() {
                return this;
            }

            @Override
            public void update(InputStream is) throws SQLException {
            }

            @Override
            public void update(Output.State state, ByteBuffer bb) throws SQLException {
            }

            @Override
            public void finish() throws SQLException {
            }

            @Override
            public void cancel() throws SQLException {
            }
        }
    }

    public static class Output
    extends OutputStream
    implements VarlenaWrapper {
        private State m_state;
        private boolean m_open = true;

        private Output(DualState.Key cookie, long resourceOwner, long context, long varlenaPtr, ByteBuffer buf) {
            this.m_state = new State(cookie, this, resourceOwner, context, varlenaPtr, buf);
        }

        public void setVerifier(Verifier v) throws IOException {
            if (!this.m_open) {
                throw new IOException("I/O operation on closed VarlenaWrapper.Output");
            }
            this.m_state.setVerifier(v);
        }

        private ByteBuffer buf(int desiredCapacity) throws IOException {
            if (!this.m_open) {
                throw new IOException("Write on closed VarlenaWrapper.Output");
            }
            try {
                return this.m_state.buffer(desiredCapacity);
            }
            catch (SQLException sqe) {
                throw new IOException("Write on varlena failed", sqe);
            }
        }

        private void pin() throws IOException {
            try {
                this.m_state.pin();
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private boolean pinUnlessReleased() {
            return this.m_state.pinUnlessReleased();
        }

        @Override
        public void write(int b) throws IOException {
            this.pin();
            try {
                ByteBuffer dst = this.buf(1);
                dst.put((byte)(b & 0xFF));
            }
            finally {
                this.m_state.unpin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.pin();
            try {
                while (0 < len) {
                    ByteBuffer dst = this.buf(len);
                    int can = dst.remaining();
                    if (can > len) {
                        can = len;
                    }
                    dst.put(b, off, can);
                    off += can;
                    len -= can;
                }
            }
            finally {
                this.m_state.unpin();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.pinUnlessReleased()) {
                return;
            }
            try {
                if (!this.m_open) {
                    return;
                }
                this.m_state.setVerifierIfNone();
                this.buf(0);
                this.m_open = false;
                this.m_state.verify();
            }
            finally {
                this.m_state.unpin();
            }
        }

        public void free() throws IOException {
            this.close();
            this.m_state.releaseFromJava();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long adopt(DualState.Key cookie) throws SQLException {
            this.m_state.pin();
            try {
                if (this.m_open) {
                    throw new SQLException("Writing of VarlenaWrapper.Output not yet complete", "55000");
                }
                long l = this.m_state.adopt(cookie);
                return l;
            }
            finally {
                this.m_state.unpin();
            }
        }

        public String toString() {
            return this.toString(this);
        }

        @Override
        public String toString(Object o) {
            return String.format("%s %s", this.m_state.toString(o), this.m_open ? "open" : "closed");
        }

        private static class State
        extends DualState.SingleMemContextDelete<Output> {
            private ByteBuffer m_buf;
            private long m_varlena;
            private Verifier m_verifier;

            private State(DualState.Key cookie, Output vr, long resourceOwner, long memContext, long varlenaPtr, ByteBuffer buf) {
                super(cookie, vr, resourceOwner, memContext);
                this.m_varlena = varlenaPtr;
                this.m_buf = buf;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ByteBuffer buffer(int desiredCapacity) throws SQLException {
                this.pin();
                try {
                    if (0 < this.m_buf.remaining() && 0 < desiredCapacity) {
                        ByteBuffer byteBuffer = this.m_buf;
                        return byteBuffer;
                    }
                    ByteBuffer filledBuf = this.m_buf;
                    Object object = Backend.THREADLOCK;
                    synchronized (object) {
                        int lstate = this.lock(true);
                        try {
                            this.m_buf = this._nextBuffer(this.m_varlena, this.m_buf.position(), desiredCapacity);
                        }
                        finally {
                            this.unlock(lstate);
                        }
                    }
                    this.m_verifier.update(this, filledBuf);
                    if (0 == desiredCapacity) {
                        this.m_verifier.update(MarkableSequenceInputStream.NO_MORE);
                    }
                    object = this.m_buf;
                    return object;
                }
                finally {
                    this.unpin();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long adopt(DualState.Key cookie) throws SQLException {
                this.adoptionLock(cookie);
                try {
                    long l = this.m_varlena;
                    return l;
                }
                finally {
                    this.adoptionUnlock(cookie);
                }
            }

            private void setVerifier(Verifier v) {
                if (null != this.m_verifier) {
                    throw new IllegalStateException("setVerifier when already set");
                }
                if (null == v) {
                    throw new NullPointerException("Null Verifier parameter");
                }
                this.m_verifier = v.schedule();
            }

            private void setVerifierIfNone() {
                if (null == this.m_verifier) {
                    this.m_verifier = Verifier.NoOp.INSTANCE;
                }
            }

            private void cancelVerifier() {
                try {
                    this.m_verifier.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private void verify() throws IOException {
                try {
                    this.m_verifier.finish();
                }
                catch (SQLException e) {
                    throw new IOException("Variable-length PostgreSQL data written failed verification", e);
                }
            }

            @Override
            public String toString(Object o) {
                return String.format("%s varlena:%x %s", super.toString(o), this.m_varlena, String.valueOf(this.m_buf).replace("java.nio.", ""));
            }

            @Override
            protected void nativeStateReleased(boolean javaStateLive) {
                this.m_buf = null;
                this.cancelVerifier();
                super.nativeStateReleased(javaStateLive);
            }

            @Override
            protected void javaStateUnreachable(boolean nativeStateLive) {
                this.m_buf = null;
                this.cancelVerifier();
                super.javaStateUnreachable(nativeStateLive);
            }

            private native ByteBuffer _nextBuffer(long var1, int var3, int var4);
        }
    }

    public static class Input
    implements VarlenaWrapper {
        private long m_parkedSize;
        private long m_bufferSize;
        private final State m_state;

        private Input(DualState.Key cookie, long resourceOwner, long context, long snapshot, long varlenaPtr, long parkedSize, long bufferSize, ByteBuffer buf) {
            this.m_parkedSize = parkedSize;
            this.m_bufferSize = bufferSize;
            this.m_state = new State(cookie, this, resourceOwner, context, snapshot, varlenaPtr, buf);
        }

        public void pin() throws SQLException {
            this.m_state.pin();
        }

        public boolean pinUnlessReleased() {
            return this.m_state.pinUnlessReleased();
        }

        public void unpin() {
            this.m_state.unpin();
        }

        public ByteBuffer buffer() throws SQLException {
            return this.m_state.buffer();
        }

        @Override
        public void close() throws IOException {
            if (this.pinUnlessReleased()) {
                return;
            }
            try {
                this.m_state.releaseFromJava();
            }
            finally {
                this.unpin();
            }
        }

        public String toString() {
            return this.toString(this);
        }

        @Override
        public String toString(Object o) {
            return String.format("%s parked:%d buffer:%d", this.m_state.toString(o), this.m_parkedSize, this.m_bufferSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long adopt(DualState.Key cookie) throws SQLException {
            this.m_state.pin();
            try {
                long l = this.m_state.adopt(cookie);
                return l;
            }
            finally {
                this.m_state.unpin();
            }
        }

        private static class State
        extends DualState.SingleMemContextDelete<Input> {
            private ByteBuffer m_buf;
            private long m_snapshot;
            private long m_varlena;

            private State(DualState.Key cookie, Input vr, long resourceOwner, long memContext, long snapshot, long varlenaPtr, ByteBuffer buf) {
                super(cookie, vr, resourceOwner, memContext);
                this.m_snapshot = snapshot;
                this.m_varlena = varlenaPtr;
                this.m_buf = null == buf ? buf : buf.asReadOnlyBuffer();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ByteBuffer buffer() throws SQLException {
                this.pin();
                try {
                    if (null != this.m_buf) {
                        ByteBuffer byteBuffer = this.m_buf;
                        return byteBuffer;
                    }
                    Object object = Backend.THREADLOCK;
                    synchronized (object) {
                        this.m_buf = this._detoast(this.m_varlena, this.guardedLong(), this.m_snapshot, this.m_resourceOwner).asReadOnlyBuffer();
                        this.m_snapshot = 0L;
                    }
                    object = this.m_buf;
                    return object;
                }
                finally {
                    this.unpin();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long adopt(DualState.Key cookie) throws SQLException {
                this.adoptionLock(cookie);
                try {
                    if (0L != this.m_snapshot) {
                        this.m_varlena = this._fetch(this.m_varlena, this.guardedLong());
                    }
                    long l = this.m_varlena;
                    return l;
                }
                finally {
                    this.adoptionUnlock(cookie);
                }
            }

            @Override
            protected void nativeStateReleased(boolean javaStateLive) {
                assert (Backend.threadMayEnterPG());
                super.nativeStateReleased(javaStateLive);
                if (0L != this.m_snapshot) {
                    this._unregisterSnapshot(this.m_snapshot, this.m_resourceOwner);
                }
                this.m_snapshot = 0L;
                this.m_buf = null;
            }

            @Override
            protected void javaStateUnreachable(boolean nativeStateLive) {
                assert (Backend.threadMayEnterPG());
                super.javaStateUnreachable(nativeStateLive);
                if (0L != this.m_snapshot) {
                    this._unregisterSnapshot(this.m_snapshot, this.m_resourceOwner);
                }
                this.m_snapshot = 0L;
                this.m_buf = null;
            }

            @Override
            public String toString(Object o) {
                return String.format("%s snap:%x varlena:%x %s", super.toString(o), this.m_snapshot, this.m_varlena, String.valueOf(this.m_buf).replace("java.nio.", ""));
            }

            private native void _unregisterSnapshot(long var1, long var3);

            private native ByteBuffer _detoast(long var1, long var3, long var5, long var7);

            private native long _fetch(long var1, long var3);
        }

        public class Stream
        extends ByteBufferInputStream
        implements VarlenaWrapper {
            private ByteBuffer m_movingBuffer;

            @Override
            protected void pin() throws IOException {
                if (!this.m_open) {
                    throw new IOException("Read from closed VarlenaWrapper");
                }
                try {
                    Input.this.pin();
                }
                catch (SQLException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }

            @Override
            protected void unpin() {
                Input.this.unpin();
            }

            @Override
            public void close() throws IOException {
                if (Input.this.pinUnlessReleased()) {
                    return;
                }
                try {
                    super.close();
                    Input.this.close();
                }
                finally {
                    this.unpin();
                }
            }

            @Override
            public String toString(Object o) {
                return String.format("%s %s", Input.this.toString(o), this.m_open ? "open" : "closed");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void verify(Verifier v) throws SQLException {
                Input.this.m_state.pin();
                try {
                    ByteBuffer buf = this.buffer();
                    State state = Input.this.m_state;
                    synchronized (state) {
                        if (0 != buf.position()) {
                            throw new SQLException("Variable-length input data to be verified  not positioned at start", "55000");
                        }
                        FilterInputStream dontCloseMe = new FilterInputStream(this){

                            @Override
                            public void close() throws IOException {
                            }
                        };
                        v.verify(dontCloseMe);
                        if (0 != buf.remaining()) {
                            throw new SQLException("Verifier finished prematurely");
                        }
                    }
                }
                catch (SQLException sqe) {
                    throw sqe;
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (Exception e) {
                    throw new SQLException("Exception verifying variable-length data: " + e.getMessage(), "XX000", e);
                }
                finally {
                    Input.this.m_state.unpin();
                }
            }

            @Override
            protected ByteBuffer buffer() throws IOException {
                try {
                    if (null == this.m_movingBuffer) {
                        ByteBuffer b = Input.this.buffer();
                        this.m_movingBuffer = b.duplicate().order(b.order());
                    }
                    return this.m_movingBuffer;
                }
                catch (SQLException sqe) {
                    throw new IOException("Read from varlena failed", sqe);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long adopt(DualState.Key cookie) throws SQLException {
                Input.this.pin();
                try {
                    if (!this.m_open) {
                        throw new SQLException("Cannot adopt VarlenaWrapper.Input after it is closed", "55000");
                    }
                    long l = Input.this.adopt(cookie);
                    return l;
                }
                finally {
                    Input.this.unpin();
                }
            }
        }
    }
}

