/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLNonTransientException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SingleRowReader;

public class SQLInputFromTuple
extends SingleRowReader
implements SQLInput {
    private int m_index = 0;
    private final int m_columns;

    public SQLInputFromTuple(DualState.Key cookie, long resourceOwner, long heapTupleHeaderPointer, TupleDesc tupleDesc) throws SQLException {
        super(cookie, resourceOwner, heapTupleHeaderPointer, tupleDesc);
        this.m_columns = tupleDesc.size();
    }

    protected int nextIndex() throws SQLException {
        if (this.m_index >= this.m_columns) {
            throw new SQLNonTransientException("Tuple has no more columns");
        }
        return ++this.m_index;
    }

    @Override
    public Array readArray() throws SQLException {
        return this.readValue(Array.class);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        Clob c = this.readClob();
        return c == null ? null : c.getAsciiStream();
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return this.readValue(BigDecimal.class);
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        Blob b = this.readBlob();
        return b == null ? null : b.getBinaryStream();
    }

    @Override
    public Blob readBlob() throws SQLException {
        byte[] bytes = this.readBytes();
        return bytes == null ? null : new BlobValue(bytes);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean b = this.readValue(Boolean.class);
        return b == null ? false : b;
    }

    @Override
    public byte readByte() throws SQLException {
        Number b = this.readNumber(Byte.TYPE);
        return b == null ? (byte)0 : b.byteValue();
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return this.readValue(byte[].class);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        Clob c = this.readClob();
        return c == null ? null : c.getCharacterStream();
    }

    @Override
    public Clob readClob() throws SQLException {
        String str = this.readString();
        return str == null ? null : new ClobValue(str);
    }

    @Override
    public Date readDate() throws SQLException {
        return this.readValue(Date.class);
    }

    @Override
    public double readDouble() throws SQLException {
        Number d = this.readNumber(Double.TYPE);
        return d == null ? 0.0 : d.doubleValue();
    }

    @Override
    public float readFloat() throws SQLException {
        Number f = this.readNumber(Float.TYPE);
        return f == null ? 0.0f : f.floatValue();
    }

    @Override
    public int readInt() throws SQLException {
        Number i = this.readNumber(Integer.TYPE);
        return i == null ? 0 : i.intValue();
    }

    @Override
    public long readLong() throws SQLException {
        Number l = this.readNumber(Long.TYPE);
        return l == null ? 0L : l.longValue();
    }

    @Override
    public Object readObject() throws SQLException {
        return this.getObject(this.nextIndex());
    }

    @Override
    public Ref readRef() throws SQLException {
        return this.readValue(Ref.class);
    }

    @Override
    public short readShort() throws SQLException {
        Number s = this.readNumber(Short.TYPE);
        return s == null ? (short)0 : s.shortValue();
    }

    @Override
    public String readString() throws SQLException {
        return this.readValue(String.class);
    }

    @Override
    public Time readTime() throws SQLException {
        return this.readValue(Time.class);
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return this.readValue(Timestamp.class);
    }

    @Override
    public URL readURL() throws SQLException {
        return this.readValue(URL.class);
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return this.readObject(SQLXML.class);
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readRowId() not implemented yet.", "0A000");
    }

    @Override
    public String readNString() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readNString() not implemented yet.", "0A000");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readNClob() not implemented yet.", "0A000");
    }

    @Override
    public <T> T readObject(Class<T> type) throws SQLException {
        return this.getObject(this.nextIndex(), type);
    }

    private Number readNumber(Class numberClass) throws SQLException {
        return this.getNumber(this.nextIndex(), numberClass);
    }

    private <T> T readValue(Class<T> valueClass) throws SQLException {
        return this.getValue(this.nextIndex(), valueClass);
    }
}

