/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlj;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SPIReadOnlyControl;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.sqlj.EntryStreamHandler;

public class Loader
extends ClassLoader {
    private static final Logger s_logger = Logger.getLogger(Loader.class.getName());
    private static final String PUBLIC_SCHEMA = "public";
    private static final Map<String, ClassLoader> s_schemaLoaders = new HashMap<String, ClassLoader>();
    private static final Map<String, Map<Oid, Class<? extends SQLData>>> s_typeMap = new HashMap<String, Map<Oid, Class<? extends SQLData>>>();
    private final Map m_entries;
    private static final Object s_j9HelperFactory;
    private static final Method s_j9GetTokenHelper;
    private static final Method s_j9FindSharedClass;
    private static final Method s_j9StoreSharedClass;
    private final Object m_j9Helper;

    public static void clearSchemaLoaders() {
        s_schemaLoaders.clear();
        s_typeMap.clear();
        Backend.clearFunctionCache();
    }

    public static ClassLoader getCurrentLoader() throws SQLException {
        String schema;
        Statement stmt = SQLUtils.getDefaultConnection().createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT pg_catalog.current_schema()");
            if (!rs.next()) {
                throw new SQLException("Unable to determine current schema");
            }
            schema = rs.getString(1);
        }
        finally {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }
        return Loader.getSchemaLoader(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSchemaLoader(String schemaName) throws SQLException {
        ClassLoader loader = s_schemaLoaders.get(schemaName = schemaName == null || schemaName.length() == 0 ? PUBLIC_SCHEMA : schemaName.toLowerCase());
        if (loader != null) {
            return loader;
        }
        HashMap<String, int[]> classImages = new HashMap<String, int[]>();
        Connection conn = SQLUtils.getDefaultConnection();
        PreparedStatement outer = null;
        PreparedStatement inner = null;
        try {
            outer = conn.prepareStatement("SELECT r.jarId FROM  sqlj.jar_repository r  INNER JOIN sqlj.classpath_entry c  ON r.jarId OPERATOR(pg_catalog.=) c.jarId WHERE c.schemaName OPERATOR(pg_catalog.=) ? ORDER BY c.ordinal DESC");
            inner = conn.prepareStatement("SELECT entryId, entryName FROM sqlj.jar_entry WHERE jarId OPERATOR(pg_catalog.=) ?");
            outer.unwrap(SPIReadOnlyControl.class).clearReadOnly();
            inner.unwrap(SPIReadOnlyControl.class).clearReadOnly();
            outer.setString(1, schemaName);
            ResultSet rs = outer.executeQuery();
            try {
                while (rs.next()) {
                    inner.setInt(1, rs.getInt(1));
                    ResultSet rs2 = inner.executeQuery();
                    try {
                        while (rs2.next()) {
                            int entryId = rs2.getInt(1);
                            String entryName = rs2.getString(2);
                            int[] oldEntry = (int[])classImages.get(entryName);
                            if (oldEntry == null) {
                                classImages.put(entryName, new int[]{entryId});
                                continue;
                            }
                            int last = oldEntry.length;
                            int[] newEntry = new int[last + 1];
                            newEntry[0] = entryId;
                            System.arraycopy(oldEntry, 0, newEntry, 1, last);
                            classImages.put(entryName, newEntry);
                        }
                    }
                    finally {
                        SQLUtils.close(rs2);
                    }
                }
            }
            finally {
                SQLUtils.close(rs);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.close(outer);
            SQLUtils.close(inner);
            throw throwable;
        }
        SQLUtils.close(outer);
        SQLUtils.close(inner);
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        loader = classImages.size() == 0 ? (schemaName.equals(PUBLIC_SCHEMA) ? parent : Loader.getSchemaLoader(PUBLIC_SCHEMA)) : new Loader(classImages, parent);
        s_schemaLoaders.put(schemaName, loader);
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Oid, Class<? extends SQLData>> getTypeMap(final String schema) throws SQLException {
        Map<Oid, Class<SQLData>> typesForSchema = s_typeMap.get(schema);
        if (typesForSchema != null) {
            return typesForSchema;
        }
        s_logger.finer("Creating typeMappings for schema " + schema);
        typesForSchema = new HashMap(){

            @Override
            public Object get(Object key) {
                s_logger.finer("Obtaining type mapping for OID " + key + " for schema " + schema);
                return super.get(key);
            }
        };
        ClassLoader loader = Loader.getSchemaLoader(schema);
        Statement stmt = SQLUtils.getDefaultConnection().createStatement();
        stmt.unwrap(SPIReadOnlyControl.class).clearReadOnly();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT javaName, sqlName FROM sqlj.typemap_entry");
            while (rs.next()) {
                try {
                    String javaClassName = rs.getString(1);
                    String sqlName = rs.getString(2);
                    Class<?> cls = loader.loadClass(javaClassName);
                    if (!SQLData.class.isAssignableFrom(cls)) {
                        throw new SQLException("Class " + javaClassName + " does not implement java.sql.SQLData");
                    }
                    Oid typeOid = Oid.forTypeName(sqlName);
                    typesForSchema.put(typeOid, cls.asSubclass(SQLData.class));
                    s_logger.finer("Adding type mapping for OID " + typeOid + " -> class " + cls.getName() + " for schema " + schema);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (typesForSchema.isEmpty()) {
                typesForSchema = Collections.EMPTY_MAP;
            }
            s_typeMap.put(schema, (Map<Oid, Class<? extends SQLData>>)typesForSchema);
            Map<Oid, Class<SQLData>> map = typesForSchema;
            return map;
        }
        finally {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }
    }

    private static URL entryURL(int entryId) {
        try {
            return new URL("dbf", "localhost", -1, "/" + entryId, EntryStreamHandler.getInstance());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    Loader(Map entries, ClassLoader parent) {
        super(parent);
        this.m_entries = entries;
        this.m_j9Helper = this.ifJ9getHelper();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        int[] entryId = (int[])this.m_entries.get(path);
        if (entryId != null) {
            ResultSet rs;
            PreparedStatement stmt;
            block6: {
                Class<?> clazz;
                Object o = this.ifJ9findSharedClass(name, entryId[0]);
                if (o instanceof byte[]) {
                    byte[] img = (byte[])o;
                    return this.defineClass(name, img, 0, img.length);
                }
                String ifJ9token = (String)o;
                stmt = null;
                rs = null;
                try {
                    stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryImage FROM sqlj.jar_entry WHERE entryId OPERATOR(pg_catalog.=) ?");
                    stmt.setInt(1, entryId[0]);
                    stmt.unwrap(SPIReadOnlyControl.class).clearReadOnly();
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block6;
                    byte[] img = rs.getBytes(1);
                    rs.close();
                    rs = null;
                    Class<?> cls = this.defineClass(name, img, 0, img.length);
                    this.ifJ9storeSharedClass(ifJ9token, cls);
                    clazz = cls;
                }
                catch (SQLException e) {
                    try {
                        Logger.getAnonymousLogger().log(Level.INFO, "Failed to load class", e);
                        throw new ClassNotFoundException(name + " due to: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.close(rs);
                        SQLUtils.close(stmt);
                        throw throwable;
                    }
                }
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                return clazz;
            }
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        int[] entryIds = (int[])this.m_entries.get(name);
        if (entryIds == null) {
            return null;
        }
        return Loader.entryURL(entryIds[0]);
    }

    protected Enumeration findResources(String name) throws IOException {
        int[] entryIds = (int[])this.m_entries.get(name);
        if (entryIds == null) {
            entryIds = new int[]{};
        }
        return new EntryEnumeration(entryIds);
    }

    private Object ifJ9getHelper() {
        if (null == s_j9HelperFactory) {
            return null;
        }
        try {
            return s_j9GetTokenHelper.invoke(s_j9HelperFactory, this);
        }
        catch (IllegalAccessException e) {
            throw new SecurityException(e);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t, t.getMessage());
        }
    }

    private Object ifJ9findSharedClass(String className, int tokenSource) {
        if (null == this.m_j9Helper) {
            return null;
        }
        String token = Integer.toString(tokenSource);
        try {
            byte[] cookie = (byte[])s_j9FindSharedClass.invoke(this.m_j9Helper, token, className);
            if (null == cookie) {
                return token;
            }
            return cookie;
        }
        catch (IllegalAccessException e) {
            throw new SecurityException(e);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t, t.getMessage());
        }
    }

    private void ifJ9storeSharedClass(String token, Class<?> cls) {
        if (null == token) {
            return;
        }
        assert (null != this.m_j9Helper);
        try {
            s_j9StoreSharedClass.invoke(this.m_j9Helper, token, cls);
        }
        catch (IllegalAccessException e) {
            throw new SecurityException(e);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t, t.getMessage());
        }
    }

    static {
        Object factory = null;
        Method getHelper = null;
        Method findShared = null;
        Method storeShared = null;
        try {
            Class<?> shared = ClassLoader.getSystemClassLoader().loadClass("com.ibm.oti.shared.Shared");
            Method getFactory = shared.getMethod("getSharedClassHelperFactory", null);
            factory = getFactory.invoke(null, new Object[0]);
            if (null != factory) {
                Class<?> factoryClass = getFactory.getReturnType();
                getHelper = factoryClass.getMethod("getTokenHelper", ClassLoader.class);
                Class<?> helperClass = getHelper.getReturnType();
                findShared = helperClass.getMethod("findSharedClass", String.class, String.class);
                storeShared = helperClass.getMethod("storeSharedClass", String.class, Class.class);
            }
        }
        catch (ClassNotFoundException shared) {
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        finally {
            s_j9HelperFactory = factory;
            s_j9GetTokenHelper = getHelper;
            s_j9FindSharedClass = findShared;
            s_j9StoreSharedClass = storeShared;
        }
    }

    static class EntryEnumeration
    implements Enumeration {
        private final int[] m_entryIds;
        private int m_top = 0;

        EntryEnumeration(int[] entryIds) {
            this.m_entryIds = entryIds;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_top < this.m_entryIds.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.m_top >= this.m_entryIds.length) {
                throw new NoSuchElementException();
            }
            return Loader.entryURL(this.m_entryIds[this.m_top++]);
        }
    }
}

