#ifndef VAR_PICK_H
#define VAR_PICK_H

#include "nodes/pg_list.h"

typedef struct VarPickerCtx
{
	/*
	 * Target columns of target scanned relation that we will need to execute
	 * the query. 
	 */
	List *target_cols;

	/*
	  The expr has a agg func call without column reference, e.g. 
	  count(*), count(1), sum(1), etc. Such a call has no args list and
	  no vars but it should be serialized.
	*/
	bool has_agg;

	/*
	  PlaceHolderVar::phexpr found from an expression, we want to simply
	  extract such PHV's exprs.
	*/
	List *phv_expr_list;
	
	/* List of phvs which assigned alias and should be treated as normal vars */
	List *nonrecursive_exprs;

	/* Do not recursively walk with aggregate function */
	bool nonrecursive_agg;

	List *aggref_pptr_list;
} VarPickerCtx;

extern bool var_picker(Node **ppnode, struct VarPickerCtx*ctx);
extern bool var_picker_hdlr(Node **ppnode, struct VarPickerCtx*ctx);
extern void reset_var_picker_ctx(VarPickerCtx *vpc);

#endif