/*-------------------------------------------------------------------------
 *
 * sha1.h
 *		Kunlun Database MySQL protocol server side implementation.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/sha1.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef SHA1_INCLUDED
#define SHA1_INCLUDED


#include <stddef.h>
#include <stdint.h>


#define SHA1_HASH_SIZE 20 /* Hash size in bytes */

void compute_sha1_hash(uint8_t *digest, const char *buf, size_t len)
        ;
void compute_sha1_hash_multi(uint8_t *digest, const char *buf1, int len1,
                             const char *buf2, int len2);

#endif /* SHA1_INCLUDED */
