/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;

public abstract class SyntheticXMLReader
implements XMLReader {
    public static final Attributes2 NO_ATTRIBUTES = new EmptyAttributes2();
    public final FluentAttributes2 m_attributes = new FluentAttributes2();
    protected static final Charset ASCII = Charset.forName("US-ASCII");
    private Set<SAX2FEATURE> m_featuresSet = EnumSet.copyOf(SAX2FEATURE.STANDARD_DEFAULTS);
    private Set<SAX2FEATURE> m_featuresKnown = EnumSet.copyOf(SAX2FEATURE.STANDARD_INITIALIZED);
    private Set<ApacheFeature> m_apacheFeaturesSet = EnumSet.copyOf(ApacheFeature.STANDARD_DEFAULTS);
    private final Object[] m_propertyValue = new Object[SAX2PROPERTY.values().length];
    private final DefaultHandler2 m_dummy = new DefaultHandler2();
    private ContentHandler m_contentHandler;
    private DTDHandler m_dtdHandler;
    private EntityResolver m_entityResolver;
    private ErrorHandler m_errorHandler;
    private ContentHandler m_contentHandler_;
    private DTDHandler m_dtdHandler_;
    private EntityResolver2 m_entityResolver_;
    private ErrorHandler m_errorHandler_;
    private DeclHandler m_declHandler_;
    private LexicalHandler m_lexicalHandler_;

    @Override
    public boolean getFeature(String uri) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAX2FEATURE f = SAX2FEATURE.fromUri(uri);
        if (this.m_featuresKnown.contains((Object)f)) {
            return this.m_featuresSet.contains((Object)f);
        }
        throw new SAXNotSupportedException(uri);
    }

    @Override
    public void setFeature(String uri, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAX2FEATURE f = SAX2FEATURE.fromUri(uri);
        if (null != f) {
            if (!f.writable) {
                throw new SAXNotSupportedException(uri);
            }
            this.m_featuresKnown.add(f);
            if (value) {
                this.m_featuresSet.add(f);
            } else {
                this.m_featuresSet.remove((Object)f);
            }
            return;
        }
        ApacheFeature af = ApacheFeature.fromUri(uri);
        if (null != af) {
            if (value) {
                this.m_apacheFeaturesSet.add(af);
            } else {
                this.m_apacheFeaturesSet.remove((Object)af);
            }
            return;
        }
        throw new SAXNotRecognizedException(uri);
    }

    @Override
    public Object getProperty(String uri) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAX2PROPERTY p = SAX2PROPERTY.fromUri(uri);
        return this.m_propertyValue[p.ordinal()];
    }

    @Override
    public void setProperty(String uri, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAX2PROPERTY p = SAX2PROPERTY.fromUri(uri);
        if (!p.writable || !p.valueOk(value)) {
            throw new SAXNotSupportedException(uri);
        }
        this.m_propertyValue[p.ordinal()] = value;
        switch (p) {
            case DECLARATION_HANDLER: {
                this.m_declHandler_ = null == value ? this.m_dummy : (DeclHandler)value;
                break;
            }
            case LEXICAL_HANDLER: {
                this.m_lexicalHandler_ = null == value ? this.m_dummy : (LexicalHandler)value;
                break;
            }
        }
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.m_entityResolver = resolver;
        this.m_entityResolver_ = null == resolver ? this.m_dummy : (resolver instanceof EntityResolver2 ? (EntityResolver2)resolver : new EntityResolverWrapper(resolver));
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.m_entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.m_dtdHandler = handler;
        this.m_dtdHandler_ = null != handler ? handler : this.m_dummy;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.m_dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.m_contentHandler = handler;
        this.m_contentHandler_ = null != handler ? handler : this.m_dummy;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.m_errorHandler = handler;
        this.m_errorHandler_ = null != handler ? handler : this.m_dummy;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    protected abstract EventCarrier next();

    @Override
    public abstract void parse(InputSource var1) throws IOException, SAXException;

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    protected final void parse() throws IOException, SAXException {
        this.m_contentHandler_.startDocument();
        try {
            EventCarrier c;
            while (null != (c = this.next())) {
                c.toSAX();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.m_contentHandler_.endDocument();
    }

    protected EventCarrier exceptionCarrier(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return new ExceptionCarrier(e);
    }

    protected Reader sysIdToReader(URI sysId, Charset cs) throws IOException, SAXException {
        InputStream is = this.sysIdToInputStream(sysId);
        if (null == is) {
            return null;
        }
        return new InputStreamReader(is, cs.newDecoder());
    }

    protected InputStream sysIdToInputStream(URI sysId) throws IOException, SAXException {
        try {
            return sysId.toURL().openStream();
        }
        catch (MalformedURLException mue) {
            throw (SAXNotSupportedException)new SAXNotSupportedException(sysId.toString()).initCause(mue);
        }
    }

    protected Reader sourceToReader(InputSource input) throws IOException, SAXException {
        URI uri;
        Reader r = input.getCharacterStream();
        if (null != r) {
            return r;
        }
        String encoding = input.getEncoding();
        Charset cs = null != encoding ? Charset.forName(encoding) : ASCII;
        InputStream is = input.getByteStream();
        if (null != is) {
            return new InputStreamReader(is, cs.newDecoder());
        }
        String sysId = input.getSystemId();
        if (null == sysId) {
            throw new SAXNotSupportedException(input.toString());
        }
        try {
            uri = new URI(sysId);
        }
        catch (URISyntaxException use) {
            throw (SAXNotSupportedException)new SAXNotSupportedException(input.toString()).initCause(use);
        }
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException(uri.toString());
        }
        r = this.sysIdToReader(uri, cs);
        if (null != r) {
            return r;
        }
        throw new SAXNotSupportedException(input.toString());
    }

    public static class FluentAttributes2
    extends Attributes2Impl {
        public FluentAttributes2 cleared() {
            this.clear();
            return this;
        }

        public FluentAttributes2 withAttribute(String localName) {
            this.addAttribute("", localName, localName, "CDATA", "");
            return this;
        }

        public FluentAttributes2 withAttribute(String localName, String value) {
            this.addAttribute("", localName, localName, "CDATA", value);
            return this;
        }

        public FluentAttributes2 withAttribute(String uri, String localName, String qName, String type, String value) {
            this.addAttribute(uri, localName, qName, type, value);
            return this;
        }

        public FluentAttributes2 withoutAttribute(int index) {
            this.removeAttribute(index);
            return this;
        }

        public FluentAttributes2 withAttribute(int index, String uri, String localName, String qName, String type, String value) {
            this.setAttribute(index, uri, localName, qName, type, value);
            return this;
        }

        public FluentAttributes2 withAttributes(Attributes atts) {
            this.setAttributes(atts);
            return this;
        }

        public FluentAttributes2 withLocalName(int index, String localName) {
            this.setLocalName(index, localName);
            return this;
        }

        public FluentAttributes2 withQName(int index, String qName) {
            this.setQName(index, qName);
            return this;
        }

        public FluentAttributes2 withType(int index, String type) {
            this.setType(index, type);
            return this;
        }

        public FluentAttributes2 withURI(int index, String uri) {
            this.setURI(index, uri);
            return this;
        }

        public FluentAttributes2 withValue(int index, String value) {
            this.setValue(index, value);
            return this;
        }

        public FluentAttributes2 withDeclared(int index, boolean value) {
            this.setDeclared(index, value);
            return this;
        }

        public FluentAttributes2 withSpecified(int index, boolean value) {
            this.setSpecified(index, value);
            return this;
        }
    }

    public static class EmptyAttributes2
    extends Attributes2Impl {
        @Override
        public void addAttribute(String uri, String localName, String qName, String type, String value) {
            throw new UnsupportedOperationException("addAttribute() to the NO_ATTRIBUTES instance");
        }

        @Override
        public void setAttributes(Attributes atts) {
            throw new UnsupportedOperationException("setAttributes() to the NO_ATTRIBUTES instance");
        }
    }

    class ExceptionCarrier
    extends EventCarrier {
        private Exception e;

        ExceptionCarrier(Exception e) {
            this.e = e;
        }

        @Override
        public void toSAX() throws IOException, SAXException, SQLException {
            if (this.e instanceof IOException) {
                throw (IOException)this.e;
            }
            if (this.e instanceof SAXException) {
                throw (SAXException)this.e;
            }
            if (this.e instanceof SQLException) {
                throw (SQLException)this.e;
            }
            throw new SQLException(this.e.getMessage(), this.e);
        }
    }

    public abstract class EventCarrier {
        protected ContentHandler content() {
            return SyntheticXMLReader.this.m_contentHandler_;
        }

        protected DTDHandler dtd() {
            return SyntheticXMLReader.this.m_dtdHandler_;
        }

        protected EntityResolver2 entity() {
            return SyntheticXMLReader.this.m_entityResolver_;
        }

        protected ErrorHandler err() {
            return SyntheticXMLReader.this.m_errorHandler_;
        }

        protected DeclHandler decl() {
            return SyntheticXMLReader.this.m_declHandler_;
        }

        protected LexicalHandler lex() {
            return SyntheticXMLReader.this.m_lexicalHandler_;
        }

        protected FluentAttributes2 attrs() {
            return SyntheticXMLReader.this.m_attributes;
        }

        protected FluentAttributes2 cleared() {
            return SyntheticXMLReader.this.m_attributes.cleared();
        }

        protected void characters(String s) throws SAXException {
            SyntheticXMLReader.this.m_contentHandler_.characters(s.toCharArray(), 0, s.length());
        }

        protected void cdataCharacters(String s) throws SAXException {
            SyntheticXMLReader.this.m_lexicalHandler_.startCDATA();
            try {
                SyntheticXMLReader.this.m_contentHandler_.characters(s.toCharArray(), 0, s.length());
            }
            finally {
                SyntheticXMLReader.this.m_lexicalHandler_.endCDATA();
            }
        }

        protected void startElement(String localName) throws SAXException {
            SyntheticXMLReader.this.m_contentHandler_.startElement("", localName, localName, NO_ATTRIBUTES);
        }

        protected void startElement(String localName, Attributes atts) throws SAXException {
            SyntheticXMLReader.this.m_contentHandler_.startElement("", localName, localName, atts);
        }

        protected void endElement(String localName) throws SAXException {
            SyntheticXMLReader.this.m_contentHandler_.endElement("", localName, localName);
        }

        public abstract void toSAX() throws IOException, SAXException, SQLException;
    }

    static class EntityResolverWrapper
    extends DefaultHandler2 {
        private final EntityResolver m_entityResolver;

        EntityResolverWrapper(EntityResolver er) {
            this.m_entityResolver = er;
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            return this.resolveEntity(publicId, systemId);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return this.m_entityResolver.resolveEntity(publicId, systemId);
        }
    }

    public static enum SAX2PROPERTY {
        DECLARATION_HANDLER("declaration-handler", DeclHandler.class),
        DOCUMENT_XML_VERSION("document-xml-version", String.class, false),
        DOM_NODE("dom-node", Node.class),
        LEXICAL_HANDLER("lexical-handler", LexicalHandler.class),
        XML_STRING("xml-string", String.class, false);

        private static final String PREFIX = "http://xml.org/sax/properties/";
        public final String propertyId;
        public final boolean writable;
        public final Class<?> requiredClass;

        public String propertyUri() {
            return PREFIX + this.propertyId;
        }

        public static SAX2PROPERTY fromUri(String uri) throws SAXNotRecognizedException {
            if (null != uri && uri.startsWith(PREFIX)) {
                String s = uri.substring(PREFIX.length());
                for (SAX2PROPERTY p : SAX2PROPERTY.values()) {
                    if (!p.propertyId.equals(s)) continue;
                    return p;
                }
            }
            throw new SAXNotRecognizedException(uri);
        }

        public boolean valueOk(Object v) {
            return null == v || this.requiredClass.isInstance(v);
        }

        private SAX2PROPERTY(String id, Class<?> reqClass) {
            this.propertyId = id;
            this.requiredClass = reqClass;
            this.writable = true;
        }

        private SAX2PROPERTY(String id, Class<?> reqClass, boolean writable) {
            this.propertyId = id;
            this.requiredClass = reqClass;
            this.writable = writable;
        }
    }

    public static enum ApacheFeature {
        DISALLOW_DOCTYPE_DECL("disallow-doctype-decl", false),
        XINCLUDE("xinclude", false),
        LOAD_EXTERNAL_DTD("nonvalidating/load-external-dtd", true);

        private static final String PREFIX = "http://apache.org/xml/features/";
        static final Set<ApacheFeature> STANDARD_DEFAULTS;
        public final String featureId;
        public final Boolean standardDefault;

        public String featureUri() {
            return PREFIX + this.featureId;
        }

        public static ApacheFeature fromUri(String uri) {
            if (null != uri && uri.startsWith(PREFIX)) {
                String s = uri.substring(PREFIX.length());
                for (ApacheFeature f : ApacheFeature.values()) {
                    if (!f.featureId.equals(s)) continue;
                    return f;
                }
            }
            return null;
        }

        private ApacheFeature(String id, Boolean standardDefault) {
            this.featureId = id;
            this.standardDefault = standardDefault;
        }

        static {
            EnumSet<ApacheFeature> dflts = EnumSet.noneOf(ApacheFeature.class);
            for (ApacheFeature f : ApacheFeature.values()) {
                if (!f.standardDefault.booleanValue()) continue;
                dflts.add(f);
            }
            STANDARD_DEFAULTS = Collections.unmodifiableSet(dflts);
        }
    }

    public static enum SAX2FEATURE {
        EXTERNAL_GENERAL_ENTITIES("external-general-entities", null),
        EXTERNAL_PARAMETER_ENTITIES("external-parameter-entities", null),
        IS_STANDALONE("is-standalone"),
        LEXICAL_HANDLER_PARAMETER_ENTITIES("lexical-handler/parameter-entities", null),
        NAMESPACES("namespaces", true),
        NAMESPACE_PREFIXES("namespace-prefixes", true),
        RESOLVE_DTD_URIS("resolve-dtd-uris", true),
        STRING_INTERNING("string-interning", true),
        UNICODE_NORMALIZATION_CHECKING("unicode-normalization-checking", true),
        USE_ATTRIBUTES2("use-attributes2", false),
        USE_LOCATOR2("use-locator2", false),
        USE_ENTITY_RESOLVER2("use-entity-resolver2", true),
        VALIDATION("validation", true),
        XMLNS_URIS("xmlns-uris", true),
        XML_1_1("xml-1.1", false);

        private static final String PREFIX = "http://xml.org/sax/features/";
        static final Set<SAX2FEATURE> STANDARD_DEFAULTS;
        static final Set<SAX2FEATURE> STANDARD_INITIALIZED;
        public final String featureId;
        public final boolean writable;
        public final Boolean standardDefault;

        public String featureUri() {
            return PREFIX + this.featureId;
        }

        public static SAX2FEATURE fromUri(String uri) {
            if (null != uri && uri.startsWith(PREFIX)) {
                String s = uri.substring(PREFIX.length());
                for (SAX2FEATURE f : SAX2FEATURE.values()) {
                    if (!f.featureId.equals(s)) continue;
                    return f;
                }
            }
            return null;
        }

        private SAX2FEATURE(String id) {
            this.featureId = id;
            this.writable = false;
            this.standardDefault = null;
        }

        private SAX2FEATURE(String id, Boolean standardDefault) {
            this.featureId = id;
            this.writable = true;
            this.standardDefault = standardDefault;
        }

        static {
            EnumSet<SAX2FEATURE> dflts = EnumSet.noneOf(SAX2FEATURE.class);
            Object inits = dflts.clone();
            for (SAX2FEATURE f : SAX2FEATURE.values()) {
                if (null == f.standardDefault) continue;
                if (f.standardDefault.booleanValue()) {
                    dflts.add(f);
                }
                ((AbstractCollection)inits).add(f);
            }
            STANDARD_DEFAULTS = Collections.unmodifiableSet(dflts);
            STANDARD_INITIALIZED = Collections.unmodifiableSet(inits);
        }
    }
}

