/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class TypeBridge<S> {
    protected final String m_canonName;
    protected final int m_defaultOid;
    protected Class<S> m_cachedClass;
    private static List<TypeBridge<?>> m_candidates = new LinkedList();

    public static <T, U extends T> Holder wrap(U o) {
        if (null == o) {
            return null;
        }
        Class<?> c = o.getClass();
        for (TypeBridge<?> tb : m_candidates) {
            if (!tb.captures(c)) continue;
            TypeBridge<?> typeBridge = tb;
            typeBridge.getClass();
            return typeBridge.new Holder(o);
        }
        if (o instanceof Holder) {
            throw new IllegalArgumentException("Not valid as argument: " + o.toString());
        }
        return null;
    }

    private TypeBridge(String cName, int dfltOid) {
        if (null == cName) {
            throw new NullPointerException("TypeBridge cName must be nonnull.");
        }
        this.m_canonName = cName;
        this.m_defaultOid = dfltOid;
        m_candidates.add(this);
    }

    private static <T> TypeBridge<T> ofClass(String cName, int dOid) {
        return new OfClass(cName, dOid);
    }

    private static <T> TypeBridge<T> ofInterface(String cName, int dOid) {
        return new OfInterface(cName, dOid);
    }

    private static <T> TypeBridge<T> of(Class<T> c, int dOid) {
        String cn = c.getCanonicalName();
        TypeBridge<T> tb = c.isInterface() ? TypeBridge.ofInterface(cn, dOid) : TypeBridge.ofClass(cn, dOid);
        tb.m_cachedClass = c;
        return tb;
    }

    public final boolean captures(Class<?> c) {
        if (null != this.m_cachedClass) {
            return this.m_cachedClass.isAssignableFrom(c);
        }
        return this.virtuallyCaptures(c);
    }

    protected abstract boolean virtuallyCaptures(Class<?> var1);

    public final class Holder {
        private final S m_payload;

        private Holder(S o) {
            this.m_payload = o;
        }

        public Class<S> bridgedClass() {
            return TypeBridge.this.m_cachedClass;
        }

        public String className() {
            return TypeBridge.this.m_canonName;
        }

        public S payload() {
            return this.m_payload;
        }

        public int defaultOid() {
            return TypeBridge.this.m_defaultOid;
        }
    }

    static final class OfInterface<S>
    extends TypeBridge<S> {
        private OfInterface(String cn, int oid) {
            super(cn, oid);
        }

        @Override
        protected boolean virtuallyCaptures(Class<?> c) {
            LinkedList q = new LinkedList();
            q.add(c);
            while (0 < q.size()) {
                c = (Class)q.remove(0);
                if (!c.isInterface()) {
                    Collections.addAll(q, c.getInterfaces());
                    if (null == (c = c.getSuperclass())) continue;
                    q.add(c);
                    continue;
                }
                if (this.m_canonName.equals(c.getCanonicalName())) {
                    this.m_cachedClass = c;
                    return true;
                }
                Collections.addAll(q, c.getInterfaces());
            }
            return false;
        }
    }

    static final class OfClass<S>
    extends TypeBridge<S> {
        private OfClass(String cn, int oid) {
            super(cn, oid);
        }

        @Override
        protected boolean virtuallyCaptures(Class<?> c) {
            while (null != c) {
                if (this.m_canonName.equals(c.getCanonicalName())) {
                    this.m_cachedClass = c;
                    return true;
                }
                c = c.getSuperclass();
            }
            return false;
        }
    }
}

