/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlj;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.postgresql.pljava.jdbc.SQLUtils;

class EntryStreamHandler
extends URLStreamHandler {
    private static EntryStreamHandler s_instance;

    EntryStreamHandler() {
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new EntryConnection(u);
    }

    static URLStreamHandler getInstance() {
        if (s_instance == null) {
            s_instance = new EntryStreamHandler();
        }
        return s_instance;
    }

    class EntryConnection
    extends URLConnection {
        private final int m_entryId;
        private String m_entryName;
        private byte[] m_image;

        protected EntryConnection(URL entryURL) {
            super(entryURL);
            this.m_entryId = Integer.parseInt(this.url.getPath().substring(1));
        }

        @Override
        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryName, entryImage FROM sqlj.jar_entry WHERE entryId OPERATOR(pg_catalog.=) ?");
                stmt.setInt(1, this.m_entryId);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new FileNotFoundException("jarId = " + this.m_entryId);
                }
                this.m_entryName = rs.getString(1);
                this.m_image = rs.getBytes(2);
                this.connected = true;
            }
            catch (SQLException e) {
                try {
                    throw new IOException(e.getMessage());
                }
                catch (Throwable throwable) {
                    SQLUtils.close(rs);
                    SQLUtils.close(stmt);
                    throw throwable;
                }
            }
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return new ByteArrayInputStream(this.m_image);
        }

        @Override
        public String getContentType() {
            return EntryConnection.getFileNameMap().getContentTypeFor(this.m_entryName);
        }
    }
}

