#ifndef PG_TABLEGROUP_H
#define PG_TABLEGROUP_H

#include "catalog/genbki.h"
#include "catalog/pg_tablegroup_d.h"

/* ----------------
 *		pg_tablegroup definition.  cpp turns this into
 *		typedef struct FormData_pg_tablegroup
 * ----------------
 */
CATALOG(pg_tablegroup,12620,TableGroupRelationId) BKI_ROWTYPE_OID(12621,TableGroupRelation_Rowtype_Id) BKI_SCHEMA_MACRO
{
	NameData	tgname;			/* table group name */
	Oid 			tgowner;		/* table group owner */
	Oid				tgparent;
	int32			tgpartcount;

#ifdef CATALOG_VARLEN			/* variable-length fields start here */
	text		reloptions[1];	/* access-method-specific options */
#endif
} FormData_pg_tablegroup;

/* ----------------
 *		Form_pg_tablegroup corresponds to a pointer to a tuple with
 *		the format of pg_tablegroup relation.
 * ----------------
 */
typedef FormData_pg_tablegroup *Form_pg_tablegroup;

#endif							/* PG_TABLEGROUP_H */
