/*-------------------------------------------------------------------------
 *
 * dbcommands.h
 *		Database management commands (create/drop database).
 *
 *
 * Portions Copyright (c) 1996-2018, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * src/include/commands/dbcommands.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef DBCOMMANDS_H
#define DBCOMMANDS_H

#include "access/xlogreader.h"
#include "catalog/objectaddress.h"
#include "lib/stringinfo.h"
#include "nodes/parsenodes.h"

extern Oid	createdb(ParseState *pstate, const CreatedbStmt *stmt);
extern void dropdb(const char *dbname, bool missing_ok);
extern ObjectAddress RenameDatabase(const char *oldname, const char *newname);
extern Oid	AlterDatabase(ParseState *pstate, AlterDatabaseStmt *stmt, bool isTopLevel);
extern Oid	AlterDatabaseSet(AlterDatabaseSetStmt *stmt);
extern ObjectAddress AlterDatabaseOwner(const char *dbname, Oid newOwnerId);

extern Oid	get_database_oid(const char *dbname, bool missingok);
extern char *get_database_name(Oid dbid);
extern int get_database_name2(Oid dbid, StringInfo str);
extern int get_database_name3(Oid dbid, NameData *nm);
extern void check_encoding_locale_matches(int encoding, const char *collate, const char *ctype);
extern  Oid init_mydboid_startup(const char *in_dbname);
extern  int get_db_enc_collate(NameData *name);
extern  void ExecDbNameMappingStmt(DbNameMappingStmt *stmt);
extern  const char* map_nspname_from_dbnames(const char*datname, const char*stordb_name, NameData *res);
extern  bool map_shard_db_name2(StringInfo qname, const char*datname, const char*nspname);
extern  const char* map_shard_db_name(const char*datname, const char*nspname, NameData *res);
extern  void drop_schema_name_mapping(const char*schema);
extern  void create_schema_name_mapping(const char*schema);

#endif							/* DBCOMMANDS_H */
