/*-------------------------------------------------------------------------
 *
 * com_data.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		MySQL command struct definitions.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/com_data.h
 *
 *-------------------------------------------------------------------------
 */
#ifndef COM_DATA_H
#define COM_DATA_H

#ifndef MYSQL_ABI_CHECK
#include "field_types.h" /* enum_field_types */
#endif

typedef struct COM_INIT_DB_DATA {
  const char *db_name;
  unsigned long length;
}COM_INIT_DB_DATA ;

typedef struct COM_REFRESH_DATA {
  unsigned char options;
}COM_REFRESH_DATA ;

typedef struct COM_KILL_DATA {
  unsigned long id;
}COM_KILL_DATA ;

typedef struct COM_SET_OPTION_DATA {
  unsigned int opt_command;
}COM_SET_OPTION_DATA ;

struct PS_PARAM;
typedef struct COM_STMT_EXECUTE_DATA {
  unsigned long stmt_id;
  /** This holds the flags, as defined in @ref enum_cursor_type */
  unsigned long open_cursor;
  struct PS_PARAM *parameters;
  unsigned long parameter_count;
  unsigned char has_new_types;
}COM_STMT_EXECUTE_DATA ;

typedef struct COM_STMT_FETCH_DATA {
  unsigned long stmt_id;
  unsigned long num_rows;
}COM_STMT_FETCH_DATA ;

typedef struct COM_STMT_SEND_LONG_DATA_DATA {
  unsigned long stmt_id;
  unsigned int param_number;
  unsigned char *longdata;
  unsigned long length;
}COM_STMT_SEND_LONG_DATA_DATA ;

typedef struct COM_STMT_PREPARE_DATA {
  const char *query;
  unsigned int length;
}COM_STMT_PREPARE_DATA ;

typedef struct COM_STMT_CLOSE_DATA {
  unsigned int stmt_id;
}COM_STMT_CLOSE_DATA ;

typedef struct COM_STMT_RESET_DATA {
  unsigned int stmt_id;
}COM_STMT_RESET_DATA ;

typedef struct COM_QUERY_DATA {
  const char *query;
  unsigned int length;
  struct PS_PARAM *parameters;
  unsigned long parameter_count;
}COM_QUERY_DATA ;

typedef struct COM_FIELD_LIST_DATA {
  unsigned char *table_name;
  unsigned int table_name_length;
  const unsigned char *query;
  unsigned int query_length;
} COM_FIELD_LIST_DATA ;

typedef union COM_DATA {
  COM_INIT_DB_DATA com_init_db;
  COM_REFRESH_DATA com_refresh;
  COM_KILL_DATA com_kill;
  COM_SET_OPTION_DATA com_set_option;
  COM_STMT_EXECUTE_DATA com_stmt_execute;
  COM_STMT_FETCH_DATA com_stmt_fetch;
  COM_STMT_SEND_LONG_DATA_DATA com_stmt_send_long_data;
  COM_STMT_PREPARE_DATA com_stmt_prepare;
  COM_STMT_CLOSE_DATA com_stmt_close;
  COM_STMT_RESET_DATA com_stmt_reset;
  COM_QUERY_DATA com_query;
  COM_FIELD_LIST_DATA com_field_list;
}COM_DATA ;

#endif /* COM_DATA_H */
