/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan {
    static final int INITIAL_CACHE_CAPACITY = 29;
    static final float CACHE_LOAD_FACTOR = 0.75f;
    public static final short SPI_READONLY_DEFAULT = 0;
    public static final short SPI_READONLY_FORCED = 1;
    public static final short SPI_READONLY_CLEARED = 2;
    private final State m_state;
    private static final Map<Object, ExecutionPlan> s_planCache;
    private final Object m_key;

    private ExecutionPlan(DualState.Key cookie, long resourceOwner, Object planKey, long spiPlan) {
        this.m_key = planKey;
        this.m_state = new State(cookie, this, resourceOwner, spiPlan);
    }

    public void close() {
        ExecutionPlan old = s_planCache.put(this.m_key, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portal cursorOpen(String cursorName, Object[] parameters, short read_only) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._cursorOpen(this.m_state.getExecutionPlanPtr(), cursorName, parameters, read_only);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._isCursorPlan(this.m_state.getExecutionPlanPtr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] parameters, short read_only, int rowCount) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return ExecutionPlan._execute(this.m_state.getExecutionPlanPtr(), parameters, read_only, rowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionPlan prepare(String statement, Oid[] argTypes) throws SQLException {
        Object key = argTypes == null ? statement : new PlanKey(statement, argTypes);
        ExecutionPlan plan = s_planCache.remove(key);
        if (plan == null) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                plan = ExecutionPlan._prepare(key, statement, argTypes);
            }
        }
        return plan;
    }

    private native Portal _cursorOpen(long var1, String var3, Object[] var4, short var5) throws SQLException;

    private static native boolean _isCursorPlan(long var0) throws SQLException;

    private static native int _execute(long var0, Object[] var2, short var3, int var4) throws SQLException;

    private static native ExecutionPlan _prepare(Object var0, String var1, Oid[] var2) throws SQLException;

    static {
        int cacheSize = Backend.getStatementCacheSize();
        s_planCache = Collections.synchronizedMap(new PlanCache(cacheSize < 11 ? 11 : cacheSize));
    }

    static final class PlanKey {
        private final int m_hashCode;
        private final String m_stmt;
        private final Oid[] m_argTypes;

        PlanKey(String stmt, Oid[] argTypes) {
            this.m_stmt = stmt;
            this.m_hashCode = stmt.hashCode() + 1;
            this.m_argTypes = argTypes;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PlanKey)) {
                return false;
            }
            PlanKey pk = (PlanKey)o;
            if (!pk.m_stmt.equals(this.m_stmt)) {
                return false;
            }
            Oid[] mat = this.m_argTypes;
            Oid[] pat = pk.m_argTypes;
            int idx = pat.length;
            if (mat.length != idx) {
                return false;
            }
            while (--idx >= 0) {
                if (pat[idx].equals(mat[idx])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }

    static final class PlanCache
    extends LinkedHashMap<Object, ExecutionPlan> {
        private final int m_cacheSize;

        public PlanCache(int cacheSize) {
            super(29, 0.75f, true);
            this.m_cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, ExecutionPlan> eldest) {
            if (this.size() <= this.m_cacheSize) {
                return false;
            }
            ExecutionPlan evicted = eldest.getValue();
            return true;
        }
    }

    private static class State
    extends DualState.SingleSPIfreeplan<ExecutionPlan> {
        private State(DualState.Key cookie, ExecutionPlan jep, long ro, long ep) {
            super(cookie, jep, ro, ep);
        }

        private long getExecutionPlanPtr() throws SQLException {
            this.pin();
            try {
                long l = this.guardedLong();
                return l;
            }
            finally {
                this.unpin();
            }
        }
    }
}

