/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import org.postgresql.pljava.ObjectPool;
import org.postgresql.pljava.PooledObject;

class ObjectPoolImpl<T extends PooledObject>
implements ObjectPool<T> {
    private static Class[] s_ctorSignature = new Class[]{ObjectPool.class};
    private static PooledObjectHandle s_handlePool;
    private static final IdentityHashMap<Class<?>, ObjectPoolImpl<?>> s_poolCache;
    private final Constructor<T> m_ctor;
    private PooledObjectHandle<T> m_providerPool;

    private ObjectPoolImpl(Class<T> c) {
        if (!PooledObject.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c + " does not implement the " + PooledObject.class + " interface");
        }
        try {
            this.m_ctor = c.getConstructor(s_ctorSignature);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to locate constructor " + c + "(ObjectPool)");
        }
    }

    public static <T extends PooledObject> ObjectPoolImpl<T> getObjectPool(Class<T> cls) {
        ObjectPoolImpl<Object> pool = s_poolCache.get(cls);
        if (pool == null) {
            pool = new ObjectPoolImpl<T>(cls);
            s_poolCache.put(cls, pool);
        }
        return pool;
    }

    @Override
    public T activateInstance() throws SQLException {
        PooledObject instance;
        PooledObjectHandle<T> handle = this.m_providerPool;
        if (handle != null) {
            this.m_providerPool = ((PooledObjectHandle)handle).m_next;
            instance = ((PooledObjectHandle)handle).m_instance;
            ((PooledObjectHandle)handle).m_instance = null;
            ((PooledObjectHandle)handle).m_next = ObjectPoolImpl.s_handlePool;
            s_handlePool = handle;
        } else {
            try {
                instance = (PooledObject)this.m_ctor.newInstance(this);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new SQLException(e.getMessage());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Failed to create an instance of: " + this.m_ctor.getDeclaringClass() + " :" + e.getMessage());
            }
        }
        try {
            instance.activate();
        }
        catch (SQLException e) {
            instance.remove();
            throw e;
        }
        return (T)instance;
    }

    @Override
    public void passivateInstance(T instance) throws SQLException {
        try {
            instance.passivate();
        }
        catch (SQLException e) {
            instance.remove();
            throw e;
        }
        PooledObjectHandle handle = s_handlePool;
        if (handle != null) {
            s_handlePool = handle.m_next;
        } else {
            handle = new PooledObjectHandle();
        }
        handle.m_instance = instance;
        handle.m_next = (PooledObjectHandle)this.m_providerPool;
        this.m_providerPool = handle;
    }

    @Override
    public void removeInstance(T instance) throws SQLException {
        PooledObjectHandle prev = null;
        PooledObjectHandle handle = this.m_providerPool;
        while (handle != null) {
            if (handle.m_instance == instance) {
                if (prev == null) {
                    this.m_providerPool = handle.m_next;
                } else {
                    prev.m_next = handle.m_next;
                }
                handle.m_instance = null;
                handle.m_next = ObjectPoolImpl.s_handlePool;
                s_handlePool = handle;
                break;
            }
            handle = handle.m_next;
        }
        instance.remove();
    }

    static {
        s_poolCache = new IdentityHashMap();
    }

    private static class PooledObjectHandle<T extends PooledObject> {
        private T m_instance;
        private PooledObjectHandle<T> m_next;

        private PooledObjectHandle() {
        }
    }
}

