/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Tuple;

public class TupleDesc {
    private final State m_state;
    private final int m_size;
    private Class[] m_columnClasses;

    TupleDesc(DualState.Key cookie, long resourceOwner, long pointer, int size) throws SQLException {
        this.m_state = new State(cookie, this, resourceOwner, pointer);
        this.m_size = size;
    }

    public final long getNativePointer() throws SQLException {
        return this.m_state.getTupleDescPtr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(int index) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._getColumnName(this.getNativePointer(), index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnIndex(String colName) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._getColumnIndex(this.getNativePointer(), colName.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple formTuple(Object[] values) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._formTuple(this.getNativePointer(), values);
        }
    }

    public int size() {
        return this.m_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getColumnClass(int index) throws SQLException {
        if (this.m_columnClasses == null) {
            this.m_columnClasses = new Class[this.m_size];
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                long _this = this.getNativePointer();
                for (int idx = 0; idx < this.m_size; ++idx) {
                    this.m_columnClasses[idx] = TupleDesc._getOid(_this, idx + 1).getJavaClass();
                }
            }
        }
        return this.m_columnClasses[index - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Oid getOid(int index) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._getOid(this.getNativePointer(), index);
        }
    }

    private static native String _getColumnName(long var0, int var2) throws SQLException;

    private static native int _getColumnIndex(long var0, String var2) throws SQLException;

    private static native Tuple _formTuple(long var0, Object[] var2) throws SQLException;

    private static native Oid _getOid(long var0, int var2) throws SQLException;

    private static class State
    extends DualState.SingleFreeTupleDesc<TupleDesc> {
        private State(DualState.Key cookie, TupleDesc td, long ro, long hth) {
            super(cookie, td, ro, hth);
        }

        private long getTupleDescPtr() throws SQLException {
            this.pin();
            try {
                long l = this.guardedLong();
                return l;
            }
            finally {
                this.unpin();
            }
        }
    }
}

