#ifndef TABLE_GROUP_H
#define TABLE_GROUP_H

#include "postgres.h"

#include "nodes/parsenodes.h"
#include "utils/rel.h"

typedef struct TableGroupOpts
{
	int32		vl_len_;		/* varlena header (do not touch directly!) */
	Oid 		shard;
	bool		frozen;
} TableGroupOpts;

/* Check that the heap's tablegroup option matches its shard option. */
extern void check_heap_tablegroup(StdRdOptions *relopts);

/* Get the option of the given tablegroup */
extern TableGroupOpts * get_tablegroup_options(const char *tgname);

extern void CreateTableGroup(CreateTableGroupStmt *stmt);
extern void AlterTableGroupOption(AlterTableGroupStmt *stmt);
extern void DropTableGroup(DropTableGroupStmt *stmt);
extern void RemoveTablegroupById(Oid tgid);
extern void AlterTableGroupOwner_oid(Oid tgid, Oid newowner);

/* Help function to adjust tablegroup's option when restore data into a new cluster */
extern size_t ModifyAllTableGroupShardid(Oid from, Oid to);

#endif
