/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.postgresql.pljava.internal.ByteBufferXMLReader;
import org.postgresql.pljava.internal.DualState;
import org.postgresql.pljava.internal.Session;
import org.postgresql.pljava.internal.VarlenaWrapper;

public abstract class VarlenaXMLRenderer
extends ByteBufferXMLReader
implements VarlenaWrapper {
    private final VarlenaWrapper.Input m_input;
    protected final CharsetDecoder m_decoder;
    private ByteBuffer m_movingBuffer;

    public VarlenaXMLRenderer(VarlenaWrapper.Input input) throws SQLException {
        this.m_input = input;
        Charset cs = Session.implServerCharset();
        if (null == cs) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SQLFeatureNotSupportedException("SQLXML: no Java Charset found to match server encoding; perhaps set org.postgresql.server.encoding system property to a valid Java charset name for the same encoding?", "0A000");
        }
        this.m_decoder = cs.newDecoder();
    }

    @Override
    public long adopt(DualState.Key cookie) throws SQLException {
        throw new UnsupportedOperationException("adopt() on a synthetic XML rendering");
    }

    public String toString() {
        return this.toString(this);
    }

    @Override
    public String toString(Object o) {
        return this.m_input.toString(o);
    }

    @Override
    protected void pin() throws SQLException {
        this.m_input.pin();
    }

    @Override
    protected void unpin() {
        this.m_input.unpin();
    }

    @Override
    protected ByteBuffer buffer() throws SQLException {
        if (null == this.m_movingBuffer) {
            ByteBuffer b = this.m_input.buffer();
            this.m_movingBuffer = b.duplicate().order(b.order());
        }
        return this.m_movingBuffer;
    }

    @Override
    public void close() throws IOException {
        this.m_input.close();
    }
}

