/*-------------------------------------------------------------------------
 *
 * charset.h
 *		Kunlun Database MySQL protocol server side implementation.
 *		charset mapping between PostgreSQL and MySQL.
 *
 * Copyright (c) 2019-2022 ZettaDB inc. All rights reserved.
 *
 * This source code is licensed under Apache 2.0 License,
 * combined with Common Clause Condition 1.0, as detailed in the NOTICE file.
 *
 * IDENTIFICATION
 *	  src/include/libmysql/charset.h
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"
#include "mb/pg_wchar.h"

typedef struct pg_mysql_charset_map
{
  pg_enc pg_charset_enc;
  uint16_t mysql_charset_num;//comes from mysql ctype*.cc
  bool is_guess;// for some 
  unsigned char mbmaxlen; // 0: undefined, not specified; positive: max NO. of bytes any char in the charset can take.
  const char*	mysql_csname; // mysql charset
  const char*  mysql_collname;// mysql collation
} pg_mysql_charset_map;

typedef struct pg_mysql_collation_map
{
  const char *pg_collname;
  pg_enc pg_charset_enc;
  uint16_t mysql_collation_code;//comes from mysql ctype*.cc
  bool is_guess;// for some 
  const char*	mysql_csname; // mysql charset
  const char*  mysql_collname;// mysql collation
} pg_mysql_collation_map;

#define INVALID_MYSQL_CHRASET_CODE 0
extern bool enable_pg_mysql_charset_mapping_guess;

extern int get_mysql_charset_number(pg_enc pg_encoding);
extern unsigned char get_encoding_max_charlen(pg_enc pg_encoding);

extern pg_enc
get_pg_cs_collation_by_mysql_cs_collation(const char *mysql_csname,
	const char *mysql_collname, NameData*pgcollname, bool missingOK);
extern pg_enc
get_pg_charset_collation_by_mysql_cs(const char *mysql_csname,
	NameData*pgcollname, bool missingOK);
extern pg_enc
get_pg_cs_collation_by_mysql_collation(const char *mysql_collname,
	NameData*pgcollname, bool missingOK);

/*
  set pg client encoding using mysql charset code specified by mysql client.
*/
extern void set_pg_client_encoding(unsigned int mysql_charset_code);
extern pg_enc get_database_charset_enc(void );

/*
  return current client charset encoding as mysql charset code
*/
inline static int get_mysql_client_charset_code()
{
  return get_mysql_charset_number(pg_get_client_encoding());
}

