/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.lang.management.ManagementFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import javax.management.JMException;
import javax.management.ObjectName;
import org.postgresql.pljava.internal.Backend;

public abstract class DualState<T>
extends WeakReference<T> {
    private static final ReferenceQueue<Object> s_releasedInstances = new ReferenceQueue();
    private static final Deque<DualState<?>> s_deferredReleased = new ArrayDeque();
    private static final IdentityHashMap<DualState, DualState> s_unscopedInstances = new IdentityHashMap();
    private static final Map<Long, ListHead> s_scopedInstances = new HashMap<Long, ListHead>();
    private DualState m_prev;
    private DualState m_next;
    private static Thread s_mutatorThread;
    private static final PinCount.Holder s_pinCount;
    private static final CleanupTracker s_inCleanup;
    private static final Statistics s_stats;
    protected final long m_resourceOwner;
    private static final int NATIVE_RELEASED = Integer.MIN_VALUE;
    private static final int JAVA_RELEASED = 0x40000000;
    private static final int MUTATOR_HOLDS = 0x20000000;
    private static final int MUTATOR_WANTS = 0x10000000;
    private static final int WAITERS_GUARD = 0x8000000;
    private static final int WAITERS_MASK = 134201344;
    private static final int WAITERS_SHIFT = 14;
    private static final int PINNERS_GUARD = 8192;
    private static final int PINNERS_MASK = 8191;
    private final AtomicInteger m_state;
    private final Queue<Thread> m_waiters;
    private static final List<?> s_nulls;

    protected static void checkCookie(Key cookie) {
        assert (Backend.threadMayEnterPG());
        if (!Key.class.isInstance(cookie)) {
            throw new UnsupportedOperationException("Operation on DualState instance without cookie");
        }
    }

    static boolean z(int i) {
        return 0 == i;
    }

    static <T> T m(T detail) {
        return detail;
    }

    protected DualState(Key cookie, T referent, long resourceOwner) {
        super(referent, s_releasedInstances);
        DualState.checkCookie(cookie);
        long scoped = 0L;
        this.m_resourceOwner = resourceOwner;
        this.m_state = new AtomicInteger();
        this.m_waiters = new ConcurrentLinkedQueue<Thread>();
        assert (Backend.threadMayEnterPG()) : DualState.m("DualState construction");
        if (0L != resourceOwner) {
            scoped = 1L;
            ListHead head = s_scopedInstances.get(resourceOwner);
            if (null == head) {
                head = new ListHead(resourceOwner);
                s_scopedInstances.put(resourceOwner, head);
            }
            this.m_prev = head;
            this.m_next = head.m_next;
            this.m_prev.m_next = this.m_next.m_prev = this;
        } else {
            s_unscopedInstances.put(this, this);
        }
        s_stats.construct(scoped);
    }

    private DualState(T referent, long resourceOwner) {
        super(referent);
        super.clear();
        this.m_resourceOwner = resourceOwner;
        this.m_prev = this.m_next = this;
        this.m_state = null;
        this.m_waiters = null;
    }

    protected void nativeStateReleased(boolean javaStateLive) {
    }

    protected void javaStateUnreachable(boolean nativeStateLive) {
    }

    protected void javaStateReleased(boolean nativeStateLive) {
        this.javaStateUnreachable(nativeStateLive);
    }

    protected final void releaseFromJava() {
        int t;
        T r1 = this.referent();
        int s = 0;
        while (!this.m_state.compareAndSet(s, t = s | 0x40000000) && DualState.z((s = this.m_state.get()) & 0x40000000)) {
        }
        super.clear();
        T r2 = this.referent();
        boolean wasClearAtEntry = s_nulls.containsAll(Arrays.asList(r1, r2));
        boolean releaseFlagWasClear = DualState.z(s & 0x40000000);
        if (wasClearAtEntry) {
            if (releaseFlagWasClear) {
                s_stats.gcReleaseRace();
                return;
            }
            s_stats.releaseReleaseRace();
            return;
        }
        if (!releaseFlagWasClear) {
            return;
        }
        if (!DualState.z(s & 0x7FFDFFF)) {
            return;
        }
        this.scheduleJavaReleased(s);
    }

    @Override
    public final boolean enqueue() {
        throw new UnsupportedOperationException("directly calling enqueue() on a DualState object is not supported; use releaseFromJava().");
    }

    @Override
    public final void clear() {
        int s = this.m_state.get();
        if (DualState.z(s & 0x40000000)) {
            throw new UnsupportedOperationException("directly calling clear() on a DualState object is not supported; use releaseFromJava().");
        }
        super.clear();
    }

    @Override
    public final T get() {
        throw new UnsupportedOperationException("directly calling get() on a DualState object is not supported.");
    }

    protected final T referent() {
        return super.get();
    }

    public final void pin() throws SQLException {
        int r = this._pin();
        if (DualState.z(r)) {
            return;
        }
        if (!DualState.z(r & Integer.MIN_VALUE)) {
            throw new SQLException(this.invalidMessage(), this.invalidSqlState());
        }
        throw new SQLException(this.releasedMessage(), this.releasedSqlState());
    }

    public final boolean pinUnlessReleased() {
        return !DualState.z(this._pin());
    }

    private final int _pin() {
        int t;
        if (s_pinCount.pin(this)) {
            return 0;
        }
        int s = this.m_state.incrementAndGet();
        if (DualState.z(s & 0xFFFFE000)) {
            return 0;
        }
        if (!DualState.z(s & 0xC0000000)) {
            return this.backoutPinBeforeEnqueue(s);
        }
        if (!DualState.z(s & 0x2000)) {
            this.m_state.decrementAndGet();
            s_pinCount.unpin(this);
            throw new Error("DualState pin tracking capacity exceeded");
        }
        Thread thr = Thread.currentThread();
        this.m_waiters.add(thr);
        while (true) {
            t = s + 16383;
            if (!DualState.z(s & 0x40000000)) {
                return this.backoutPinAfterEnqueue(s);
            }
            if (!DualState.z(s & 0x2000)) {
                this.backoutPinAfterEnqueue(s);
                throw new Error("DualState wait tracking capacity exceeded");
            }
            if (!DualState.z(t & 0x10000000) && DualState.z(t & 0x1FFF)) {
                t += 0x10000000;
            }
            if (this.m_state.compareAndSet(s, t)) break;
            s = this.m_state.get();
        }
        if (!DualState.z(t & 0x20000000) && !DualState.z(s & 0x10000000)) {
            LockSupport.unpark(s_mutatorThread);
        }
        while (true) {
            if (!thr.isInterrupted()) {
                LockSupport.park(this);
            }
            s = this.m_state.get();
            if (thr.isInterrupted() || !DualState.z(s & 0xC0000000)) {
                return this.backoutPinAfterPark(s, t);
            }
            if (DualState.z(s & 0x20000000) && (DualState.z(s & 0x10000000) || !DualState.z(t & 0x20000000) || !this.m_waiters.contains(thr))) break;
            t = s;
        }
        return 0;
    }

    public final void unpin() {
        int t;
        if (s_pinCount.unpin(this)) {
            return;
        }
        int s = 1;
        while (true) {
            assert (1 <= (s & 0x1FFF)) : DualState.m("DualState unpin < 1 pinner");
            t = s - 1;
            if (!DualState.z(t & 0x10000000) && DualState.z(t & 0x1FFF)) {
                t += 0x10000000;
            }
            if (this.m_state.compareAndSet(s, t)) break;
            s = this.m_state.get();
        }
        if (!DualState.z(t & 0x40000000) && DualState.z(t & 0x7FFDFFF)) {
            this.scheduleJavaReleased(t);
        }
        if (!DualState.z(t & 0x20000000) && !DualState.z(s & 0x10000000)) {
            LockSupport.unpark(s_mutatorThread);
        }
    }

    public final boolean pinnedByCurrentThread() {
        return s_pinCount.hasPin(this) || s_inCleanup.inCleanup();
    }

    private int backoutPinBeforeEnqueue(int s) {
        int t;
        s_pinCount.unpin(this);
        while (true) {
            assert (1 <= (s & 0x1FFF)) : DualState.m("backoutPinBeforeEnqueue");
            t = s - 1;
            if (!DualState.z(t & 0x10000000) && DualState.z(t & 0x1FFF)) {
                t += 0x10000000;
            }
            if (this.m_state.compareAndSet(s, t)) break;
            s = this.m_state.get();
        }
        if (!DualState.z(t & 0x40000000) && DualState.z(t & 0x7FFDFFF)) {
            this.scheduleJavaReleased(t);
        }
        if (!DualState.z(t & 0x20000000) && !DualState.z(s & 0x10000000)) {
            LockSupport.unpark(s_mutatorThread);
        }
        return t & 0xC0000000;
    }

    private int backoutPinAfterEnqueue(int s) {
        this.m_waiters.remove(Thread.currentThread());
        return this.backoutPinBeforeEnqueue(s);
    }

    private int backoutPinAfterPark(int s, int t) {
        int delta;
        boolean mustUnpin;
        boolean wasHolds;
        boolean bl = wasHolds = !DualState.z(t & 0x20000000);
        while (!this.m_state.compareAndSet(s, t = s + 1)) {
            s = this.m_state.get();
        }
        boolean bl2 = mustUnpin = DualState.z(t & 0x30000000) || DualState.z(t & 0x20000000) && (wasHolds || !this.m_waiters.contains(Thread.currentThread()));
        if (mustUnpin) {
            delta = 1;
            assert (1 < (t & 0x1FFF)) : DualState.m("backoutPinAfterPark(acquired)");
        } else {
            delta = 16384;
            assert (delta <= (t & 0x7FFC000)) : DualState.m("backoutPinAfterPark");
        }
        s = t;
        while (!this.m_state.compareAndSet(s, t = s - delta)) {
            s = this.m_state.get();
        }
        if (mustUnpin) {
            this.unpin();
        } else {
            t = this.backoutPinAfterEnqueue(t);
        }
        if (Thread.interrupted()) {
            throw (CancellationException)new CancellationException("Interrupted waiting for pin").initCause(new InterruptedException());
        }
        return t & 0xC0000000;
    }

    private void scheduleJavaReleased(int s) {
        super.enqueue();
        if (Backend.threadMayEnterPG()) {
            DualState.cleanEnqueuedInstances();
        }
    }

    protected final int lock(boolean upgrade) {
        int t;
        if (!Backend.threadMayEnterPG()) {
            throw new IllegalThreadStateException("This thread may not mutate a DualState object");
        }
        s_mutatorThread = Thread.currentThread();
        assert (!upgrade || this.pinnedByCurrentThread()) : DualState.m("upgrade without pin");
        int s = upgrade ? 1 : 0;
        int contended = 0;
        while (true) {
            t = s;
            if (upgrade) {
                t += 16383;
            }
            if (this.m_state.compareAndSet(s, t |= !DualState.z(t & 0x1FFF) ? 0x10000000 : 0x20000000)) break;
            s = this.m_state.get();
            if (!DualState.z(s & 0x20000000)) {
                return s & 0xE0000000;
            }
            if (!DualState.z(s & 0x1FFF)) continue;
            upgrade = false;
        }
        while (DualState.z(t & 0x20000000)) {
            contended = 1;
            LockSupport.park(this);
            t = this.m_state.get();
        }
        s_stats.lockContended(contended);
        return t & 0xC0000000 | (upgrade ? 1 : 0);
    }

    protected final void unlock(int s) {
        this.unlock(s, false);
    }

    protected final void unlock(int s, boolean isNativeRelease) {
        Thread thr;
        int t;
        if (!DualState.z(s & 0x20000000)) {
            if (isNativeRelease && DualState.z(s & Integer.MIN_VALUE)) {
                int t2;
                while (!this.m_state.compareAndSet(s, t2 = s | Integer.MIN_VALUE)) {
                    s = this.m_state.get();
                }
            }
            return;
        }
        boolean upgrade = !DualState.z(s & 1);
        int release = isNativeRelease ? Integer.MIN_VALUE : 0;
        s = 0x20000000;
        if (upgrade) {
            s |= 0x4000;
        }
        while (true) {
            t = s & 0xD8002000;
            if (this.m_state.compareAndSet(s &= 0xFFFFE000, t |= release | (s & 0x7FFC000) >>> 14)) break;
            s = this.m_state.get();
            assert (!DualState.z(s & 0x20000000)) : DualState.m("DualState mispaired unlock");
            if (DualState.z(s & 0x1FFF)) continue;
            Thread.yield();
        }
        t &= 0x1FFF;
        if (upgrade) {
            --t;
        }
        s_stats.pinContended(t);
        while (null != (thr = this.m_waiters.poll())) {
            --t;
            LockSupport.unpark(thr);
        }
        assert (0 == t) : DualState.m("Miscount of DualState wait queue");
    }

    protected final void adoptionLock(Key cookie) throws SQLException {
        DualState.checkCookie(cookie);
        s_mutatorThread = Thread.currentThread();
        assert (this.pinnedByCurrentThread()) : DualState.m("adoptionLock without pin");
        int s = 1;
        int t = -536854528;
        if (!this.m_state.compareAndSet(s, t)) {
            throw new SQLException("Attempt by PostgreSQL to adopt a released or non-quiescent Java object");
        }
    }

    protected final void adoptionUnlock(Key cookie) throws SQLException {
        DualState.checkCookie(cookie);
        int s = -536854528;
        int t = -1073741823;
        this.nativeStateReleased(false);
        if (!this.m_state.compareAndSet(s, t)) {
            throw new SQLException("Release failed while adopting Java object");
        }
    }

    protected String identifierForMessage() {
        T referent = this.referent();
        String id = null != referent ? referent.getClass().getName() : this.getClass().getName();
        return id;
    }

    protected String invalidMessage() {
        return this.identifierForMessage() + " used beyond its PostgreSQL lifetime";
    }

    protected String releasedMessage() {
        return this.identifierForMessage() + " used after released by Java";
    }

    protected String invalidSqlState() {
        return "55000";
    }

    protected String releasedSqlState() {
        return "55000";
    }

    public String toString() {
        return this.toString(this);
    }

    public String toString(Object o) {
        Class<?> c = (null == o ? this : o).getClass();
        String cn = c.getCanonicalName();
        int pnl = c.getPackage().getName().length();
        return String.format("%s owner:%x %s", cn.substring(1 + pnl), this.m_resourceOwner, DualState.z(this.m_state.get() & Integer.MIN_VALUE) ? "fresh" : "stale");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resourceOwnerRelease(long resourceOwner) {
        long total = 0L;
        long release = 0L;
        assert (Backend.threadMayEnterPG()) : DualState.m("resourceOwnerRelease thread");
        DualState head = s_scopedInstances.remove(resourceOwner);
        if (null == head) {
            return;
        }
        DualState t = head.m_next;
        head.m_next = null;
        head.m_prev = null;
        DualState s = t;
        while (s != head) {
            t = s.m_next;
            s.m_next = null;
            s.m_prev = null;
            ++total;
            int state = s.lock(false);
            try {
                if (DualState.z(Integer.MIN_VALUE & state)) {
                    ++release;
                    s.nativeStateReleased(DualState.z(0x40000000 & state) && null != s.referent());
                }
            }
            finally {
                s.unlock(state, true);
            }
            s = t;
        }
        s_stats.resourceOwnerPoll(release, total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanEnqueuedInstances() {
        long reDefer;
        long release;
        long total;
        block14: {
            total = 0L;
            release = 0L;
            reDefer = 0L;
            int nDeferred = s_deferredReleased.size();
            assert (s_inCleanup.enter());
            block5: while (true) {
                while (true) {
                    DualState s;
                    boolean isDeferred;
                    boolean bl = isDeferred = 0 < nDeferred;
                    if (isDeferred) {
                        --nDeferred;
                        s = s_deferredReleased.remove();
                    } else {
                        s = (DualState)s_releasedInstances.poll();
                        if (null == s) {
                            break block14;
                        }
                    }
                    int state = s.m_state.get();
                    if (!DualState.z(0x7FFDFFF & state)) {
                        s_deferredReleased.add(s);
                        if (!isDeferred) continue;
                        ++reDefer;
                        continue;
                    }
                    ++total;
                    s.delist();
                    try {
                        if (!DualState.z(0x40000000 & state)) {
                            ++release;
                            s.javaStateReleased(DualState.z(Integer.MIN_VALUE & state));
                            continue block5;
                        }
                        if (!DualState.z(Integer.MIN_VALUE & state)) continue block5;
                        s.javaStateUnreachable(DualState.z(Integer.MIN_VALUE & state));
                        continue block5;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                assert (s_inCleanup.exit());
            }
        }
        s_stats.referenceQueueDrain(total - release, release, total, reDefer);
    }

    private void delist() {
        assert (Backend.threadMayEnterPG()) : DualState.m("DualState delist thread");
        if (0L == this.m_resourceOwner) {
            if (null != s_unscopedInstances.remove(this)) {
                s_stats.delistUnscoped();
            }
            return;
        }
        if (null == this.m_prev || null == this.m_next) {
            return;
        }
        if (this == this.m_prev.m_next) {
            this.m_prev.m_next = this.m_next;
        }
        if (this == this.m_next.m_prev) {
            this.m_next.m_prev = this.m_prev;
        }
        this.m_next = null;
        this.m_prev = null;
        s_stats.delistScoped();
    }

    static {
        s_pinCount = new PinCount.Holder();
        s_inCleanup = new CleanupTracker();
        s_stats = new Statistics();
        try {
            ObjectName n = new ObjectName("org.postgresql.pljava:type=DualState,name=Statistics");
            ManagementFactory.getPlatformMBeanServer().registerMBean(s_stats, n);
        }
        catch (JMException jMException) {
            // empty catch block
        }
        s_nulls = Arrays.asList(new Object[]{null});
    }

    static class Statistics
    implements StatisticsMBean {
        private long constructed = 0L;
        private long enlistedScoped = 0L;
        private long enlistedUnscoped = 0L;
        private long delistedScoped = 0L;
        private long delistedUnscoped = 0L;
        private long javaUnreachable = 0L;
        private long javaReleased = 0L;
        private long nativeReleased = 0L;
        private long resourceOwnerPasses = 0L;
        private long referenceQueuePasses = 0L;
        private long referenceQueueItems = 0L;
        private long contendedLocks = 0L;
        private long contendedPins = 0L;
        private long repeatedlyDeferred = 0L;
        private AtomicInteger gcRelRaces = new AtomicInteger();
        private AtomicInteger relRelRaces = new AtomicInteger();

        Statistics() {
        }

        @Override
        public long getConstructed() {
            return this.constructed;
        }

        @Override
        public long getEnlistedScoped() {
            return this.enlistedScoped;
        }

        @Override
        public long getEnlistedUnscoped() {
            return this.enlistedUnscoped;
        }

        @Override
        public long getDelistedScoped() {
            return this.delistedScoped;
        }

        @Override
        public long getDelistedUnscoped() {
            return this.delistedUnscoped;
        }

        @Override
        public long getJavaUnreachable() {
            return this.javaUnreachable;
        }

        @Override
        public long getJavaReleased() {
            return this.javaReleased;
        }

        @Override
        public long getNativeReleased() {
            return this.nativeReleased;
        }

        @Override
        public long getResourceOwnerPasses() {
            return this.resourceOwnerPasses;
        }

        @Override
        public long getReferenceQueuePasses() {
            return this.referenceQueuePasses;
        }

        @Override
        public long getReferenceQueueItems() {
            return this.referenceQueueItems;
        }

        @Override
        public long getContendedLocks() {
            return this.contendedLocks;
        }

        @Override
        public long getContendedPins() {
            return this.contendedPins;
        }

        @Override
        public long getRepeatedlyDeferred() {
            return this.repeatedlyDeferred;
        }

        @Override
        public int getGcReleaseRaces() {
            return this.gcRelRaces.get();
        }

        @Override
        public int getReleaseReleaseRaces() {
            return this.relRelRaces.get();
        }

        final void construct(long scoped) {
            ++this.constructed;
            this.enlistedScoped += scoped;
            this.enlistedUnscoped += 1L - scoped;
        }

        final void resourceOwnerPoll(long released, long total) {
            ++this.resourceOwnerPasses;
            this.nativeReleased += released;
            this.delistedScoped += total;
        }

        final void javaRelease(long scoped, long unscoped) {
            ++this.javaReleased;
            this.delistedScoped += scoped;
            this.delistedUnscoped += unscoped;
        }

        final void referenceQueueDrain(long unreachable, long release, long total, long reDefer) {
            ++this.referenceQueuePasses;
            this.referenceQueueItems += total;
            this.javaUnreachable += unreachable;
            this.javaReleased += release;
            this.repeatedlyDeferred += reDefer;
        }

        final void delistScoped() {
            ++this.delistedScoped;
        }

        final void delistUnscoped() {
            ++this.delistedUnscoped;
        }

        final void javaRelease() {
            ++this.javaReleased;
        }

        final void lockContended(int n) {
            this.contendedLocks += (long)n;
        }

        final void pinContended(int n) {
            this.contendedPins += (long)n;
        }

        final void gcReleaseRace() {
            this.gcRelRaces.getAndIncrement();
        }

        final void releaseReleaseRace() {
            this.gcRelRaces.getAndIncrement();
        }
    }

    public static interface StatisticsMBean {
        public long getConstructed();

        public long getEnlistedScoped();

        public long getEnlistedUnscoped();

        public long getDelistedScoped();

        public long getDelistedUnscoped();

        public long getJavaUnreachable();

        public long getJavaReleased();

        public long getNativeReleased();

        public long getResourceOwnerPasses();

        public long getReferenceQueuePasses();

        public long getReferenceQueueItems();

        public long getContendedLocks();

        public long getContendedPins();

        public long getRepeatedlyDeferred();

        public int getGcReleaseRaces();

        public int getReleaseReleaseRaces();
    }

    public static abstract class SingleSPIcursorClose<T>
    extends SingleGuardedLong<T> {
        protected SingleSPIcursorClose(Key cookie, T referent, long resourceOwner, long ccTarget) {
            super(cookie, referent, resourceOwner, ccTarget);
        }

        @Override
        public String formatString() {
            return "%s SPI_cursor_close(%x)";
        }

        @Override
        protected void javaStateUnreachable(boolean nativeStateLive) {
            assert (Backend.threadMayEnterPG());
            if (nativeStateLive) {
                this._spiCursorClose(this.guardedLong());
            }
        }

        private native void _spiCursorClose(long var1);
    }

    public static abstract class SingleSPIfreeplan<T>
    extends SingleGuardedLong<T> {
        protected SingleSPIfreeplan(Key cookie, T referent, long resourceOwner, long fpTarget) {
            super(cookie, referent, resourceOwner, fpTarget);
        }

        @Override
        public String formatString() {
            return "%s SPI_freeplan(%x)";
        }

        @Override
        protected void javaStateUnreachable(boolean nativeStateLive) {
            assert (Backend.threadMayEnterPG());
            if (nativeStateLive) {
                this._spiFreePlan(this.guardedLong());
            }
        }

        private native void _spiFreePlan(long var1);
    }

    public static abstract class SingleFreeErrorData<T>
    extends SingleGuardedLong<T> {
        protected SingleFreeErrorData(Key cookie, T referent, long resourceOwner, long fedTarget) {
            super(cookie, referent, resourceOwner, fedTarget);
        }

        @Override
        public String formatString() {
            return "%s FreeErrorData(%x)";
        }

        @Override
        protected void javaStateUnreachable(boolean nativeStateLive) {
            assert (Backend.threadMayEnterPG());
            if (nativeStateLive) {
                this._freeErrorData(this.guardedLong());
            }
        }

        private native void _freeErrorData(long var1);
    }

    public static abstract class SingleHeapFreeTuple<T>
    extends SingleGuardedLong<T> {
        protected SingleHeapFreeTuple(Key cookie, T referent, long resourceOwner, long hftTarget) {
            super(cookie, referent, resourceOwner, hftTarget);
        }

        @Override
        public String formatString() {
            return "%s heap_freetuple(%x)";
        }

        @Override
        protected void javaStateUnreachable(boolean nativeStateLive) {
            assert (Backend.threadMayEnterPG());
            if (nativeStateLive) {
                this._heapFreeTuple(this.guardedLong());
            }
        }

        private native void _heapFreeTuple(long var1);
    }

    public static abstract class SingleFreeTupleDesc<T>
    extends SingleGuardedLong<T> {
        protected SingleFreeTupleDesc(Key cookie, T referent, long resourceOwner, long ftdTarget) {
            super(cookie, referent, resourceOwner, ftdTarget);
        }

        @Override
        public String formatString() {
            return "%s FreeTupleDesc(%x)";
        }

        @Override
        protected void javaStateUnreachable(boolean nativeStateLive) {
            assert (Backend.threadMayEnterPG());
            if (nativeStateLive) {
                this._freeTupleDesc(this.guardedLong());
            }
        }

        private native void _freeTupleDesc(long var1);
    }

    public static abstract class SingleMemContextDelete<T>
    extends SingleGuardedLong<T> {
        protected SingleMemContextDelete(Key cookie, T referent, long resourceOwner, long memoryContext) {
            super(cookie, referent, resourceOwner, memoryContext);
        }

        @Override
        public String formatString() {
            return "%s MemoryContextDelete(%x)";
        }

        @Override
        protected void javaStateUnreachable(boolean nativeStateLive) {
            assert (Backend.threadMayEnterPG());
            if (nativeStateLive) {
                this._memContextDelete(this.guardedLong());
            }
        }

        private native void _memContextDelete(long var1);
    }

    public static abstract class SinglePfree<T>
    extends SingleGuardedLong<T> {
        protected SinglePfree(Key cookie, T referent, long resourceOwner, long pfreeTarget) {
            super(cookie, referent, resourceOwner, pfreeTarget);
        }

        @Override
        protected String formatString() {
            return "%s pfree(%x)";
        }

        @Override
        protected void javaStateUnreachable(boolean nativeStateLive) {
            assert (Backend.threadMayEnterPG());
            if (nativeStateLive) {
                this._pfree(this.guardedLong());
            }
        }

        private native void _pfree(long var1);
    }

    public static abstract class SingleGuardedLong<T>
    extends DualState<T> {
        private final long m_guardedLong;

        protected SingleGuardedLong(Key cookie, T referent, long resourceOwner, long guardedLong) {
            super(cookie, referent, resourceOwner);
            this.m_guardedLong = guardedLong;
        }

        @Override
        public String toString(Object o) {
            return String.format(this.formatString(), super.toString(o), this.m_guardedLong);
        }

        protected String formatString() {
            return "%s GuardedLong(%x)";
        }

        protected final long guardedLong() {
            assert (this.pinnedByCurrentThread()) : SingleGuardedLong.m("guardedLong() without pin");
            return this.m_guardedLong;
        }
    }

    private static class ListHead
    extends DualState<String> {
        private ListHead(long owner) {
            super("", owner);
        }

        @Override
        public String toString(Object o) {
            return String.format("DualState.ListHead for resource owner %x", this.m_resourceOwner);
        }
    }

    public static final class Key {
        private static boolean constructed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Key() {
            Class<Key> clazz = Key.class;
            synchronized (Key.class) {
                if (constructed) {
                    throw new IllegalStateException("Duplicate DualState.Key");
                }
                constructed = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    static final class CleanupTracker
    extends ThreadLocal<Boolean> {
        CleanupTracker() {
        }

        boolean enter() {
            assert (Backend.threadMayEnterPG()) : DualState.m("inCleanup.enter thread");
            assert (!this.inCleanup()) : DualState.m("inCleanup.enter re-entered");
            this.set(Boolean.TRUE);
            return true;
        }

        boolean exit() {
            assert (this.inCleanup()) : DualState.m("inCleanup.exit mispaired");
            this.set(Boolean.FALSE);
            return true;
        }

        boolean inCleanup() {
            return Boolean.TRUE == this.get();
        }
    }

    static final class PinCount {
        DualState<?> m_referent;
        short m_count;

        PinCount(DualState<?> referent) {
            if (null == referent) {
                throw new NullPointerException("null referent of a PinCount");
            }
            this.m_referent = referent;
        }

        static final class Manager {
            private static final int INITIAL_SIZE = 4;
            private static final int POOL_TARGET = 2;
            private PinCount[] m_array = new PinCount[4];
            private int m_top = -1;
            private int m_pooled = 0;

            Manager() {
            }

            PinCount peek() {
                if (this.m_top >= 0) {
                    return this.m_array[this.m_top];
                }
                return null;
            }

            void pop() {
                if (this.m_top < 0) {
                    throw new NoSuchElementException();
                }
                if (this.m_pooled >= 2) {
                    this.m_array[this.m_top] = null;
                } else {
                    PinCount pc = this.m_array[this.m_top];
                    pc.m_referent = null;
                    assert (0 == pc.m_count) : "won't pop a nonzero PinCount";
                    ++this.m_pooled;
                }
                --this.m_top;
            }

            PinCount push(DualState<?> s) {
                PinCount pc = this.allocate(s);
                ++this.m_top;
                if (this.m_top < this.m_array.length) {
                    assert (this.m_top + this.m_pooled < this.m_array.length) : "stack v. pool";
                } else {
                    assert (0 == this.m_pooled) : "pool will be empty if extending";
                    this.m_array = Arrays.copyOf(this.m_array, 2 * this.m_array.length);
                }
                this.m_array[this.m_top] = pc;
                return pc;
            }

            private PinCount allocate(DualState<?> s) {
                if (this.m_pooled > 0) {
                    PinCount pc = this.m_array[1 + this.m_top];
                    --this.m_pooled;
                    pc.m_referent = s;
                    return pc;
                }
                return new PinCount(s);
            }

            private boolean hasPin(DualState<?> s) {
                int i = 1 + this.m_top;
                while (i-- > 0) {
                    PinCount pc = this.m_array[i];
                    if (!pc.m_referent.equals(s) || 0 >= pc.m_count) continue;
                    return true;
                }
                return false;
            }
        }

        static final class Holder
        extends ThreadLocal<Manager> {
            Holder() {
            }

            @Override
            protected Manager initialValue() {
                return new Manager();
            }

            boolean pin(DualState<?> s) {
                boolean result = false;
                Manager counts = (Manager)this.get();
                PinCount pc = counts.peek();
                if (null == pc || !pc.m_referent.equals(s)) {
                    result = counts.hasPin(s);
                    pc = counts.push(s);
                }
                short s2 = pc.m_count;
                pc.m_count = (short)(s2 + 1);
                if (0 < s2) {
                    return true;
                }
                return result;
            }

            boolean unpin(DualState<?> s) {
                Manager counts = (Manager)this.get();
                PinCount pc = counts.peek();
                if (null == pc || !pc.m_referent.equals(s)) {
                    throw new IllegalThreadStateException("mispairing of DualState pin/unpin");
                }
                pc.m_count = (short)(pc.m_count - 1);
                if (0 == pc.m_count) {
                    counts.pop();
                    return counts.hasPin(s);
                }
                return true;
            }

            boolean hasPin(DualState<?> s) {
                return ((Manager)this.get()).hasPin(s);
            }
        }
    }
}

