#ifndef SHARDING_STMT_UTILS_H
#define SHARDING_STMT_UTILS_H

#include "sharding/stmt_hdl.h"

/**
 * @brief Bind datum to parameters of prepared stmt.
 *  Help function used in mysql binary procotals.
 * 
 * @return int   0 if sucess,  else -1
 */
extern int bind_stmt_param_impl(StmtHandle *handle, List *param_list);

/**
 * @brief Bind result buffer to the executed stmt.
 * Help function used in mysql binary protocals.
 * 
 * @return int   0 if sucess,  else -1
 */
extern int bind_stmt_result_impl(StmtHandle *handle);

/**
 * @brief Deserialize current mysql row into pg format's datum
 */
extern void deserialize_stmt_result(StmtHandle *handle, Datum *output, bool *nulls, int buf_len);


/**
 * @brief Cache newly created statement into cache, and mark it inuse
 */
extern void cache_prepared_stmt(Oid nodeid, const char *query, int len, bool cursor, struct st_mysql_stmt *stmt);

/**
 * @brief FInd idle prepared statement with the digest query and on shard nodeid
 */
extern struct st_mysql_stmt *find_prepared_stmt(Oid nodeid, const char *query, int len, bool cursor);

/**
 * @brief Mark the given statement inuse=false, then other routine can reuse it by call find_prepared_stmt(..)
 */
extern void free_prepared_stmt(Oid nodeid, uint32 hashkey, struct st_mysql_stmt *stmt, bool suspend);

/**
 * @brief Clean up all the prepared statement on shard with id = 'nodeid'
 */
extern void cleanup_prepared_stmts(Oid nodeid);

#endif