<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AutoService extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->config->load('myconfig');
		$this->key = $this->config->item('key');
	}

	public function findUrl()
	{
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//验证token
		$this->load->model('Login_model');
		$res_token = $this->Login_model->getToken($token, 'D', $this->key);
		//print_r($res_token);exit;
		if (!empty($res_token)) {
			//先查表是否存在
			$sqlexist = "select TABLE_NAME from information_schema.TABLES where TABLE_NAME = 'auto_customer_service';";
			$resexist = $this->Login_model->getList($sqlexist);
			if ($resexist !== false) {
				$sql = "select hostaddr,port from auto_customer_service ";
				$res = $this->Login_model->getList($sql);
				if (!empty($res)) {
					$data['code'] = 200;
					$data['hostaddr'] = $res[0]['hostaddr'];
					$data['port'] = $res[0]['port'];
				}
			}else{
				$data['code'] = 501;
				$data['message'] = '请先配置url再使用该功能';
			}
		}else{
			$data['code'] = 500;
			$data['message'] = 'token错误';
		}
		print_r(json_encode($data));
	}

	public function getAI()
	{
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		//调接口
		$this->load->model('Cluster_model');
		$post_arr = $this->Cluster_model->postData($string['content'],'http://'.$string['hostaddr'].':'. $string['port']);
		$post_arr = json_decode($post_arr, TRUE);
		$data = $post_arr;
		print_r(json_encode($data));
	}
	public function setAddr()
	{ //无判断权限
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		$url = $string['url'];
		$arr=explode('//',$url);
		$hosts=explode(':',$arr[1]);
		$this->load->model('Login_model');

		try {
			//如不存在创建表

		} catch (\Throwable $th) {
			//throw $th;
		}

		if ($res == 0) {
			$select_sql = "select id from auto_customer_service where hostaddr='$hosts[0]' and port='$hosts[1]' ";
			$res_select = $this->Login_model->getList($select_sql);
			if(!empty($res_select)){
				$data['code'] = 301;
				$data['message'] = '该url已经存在，无需重复设置';
			}else{
				$insert_sql = "insert into auto_customer_service(hostaddr,port) values ('$hosts[0]','$hosts[1]'); ";
				$res_insert = $this->Login_model->updateList($insert_sql);
				if ($res_insert == 1) {
					$data['code'] = 200;
					$data['message'] = '设置成功';
				} else {
					$data['code'] = 501;
					$data['message'] = '设置失败';
				}
			}
			print_r(json_encode($data));
		} else {
			print_r(json_encode($res));
		}
	}
}
