<?php
defined('BASEPATH') or exit('No direct script access allowed');

class DataCenter extends CI_Controller
{

	public function __construct()
	{
		//session_start();
		parent::__construct();
		$this->config->load('myconfig');
		$this->key = $this->config->item('key');
		$this->post_url = $this->config->item('post_url');
	}

	public function getIDCList()
	{
		//header('Content-Type:text/html;charset=utf-8');
		//GET请求
		$serve = $_SERVER['QUERY_STRING'];
		$string = preg_split('/[=&]/', $serve);
		$arr = array();
		for ($i = 0; $i < count($string); $i += 2) {
			$arr[$string[$i]] = $string[$i + 1];
		}
		$pageNo = $arr['pageNo'];
		$pageSize = $arr['pageSize'];
		$username = $arr['name'];
		$city= urldecode($arr['city']);
		$province=urldecode($arr['province']);
		$start = ($pageNo - 1) * $pageSize;

		$this->load->model('Cluster_model');
		$sql = "select id,name,owner,province,city  from data_centers where 1=1";
		if (!empty($username)) {
			$sql .= " and  name like '%{$username}%' ";
		}
		if (!empty($province)) {
			$sql .= " and province like '%{$province}%' ";
		}
		if (!empty($city)) {
			$sql .= " and  city like '%{$city}%' ";
		}
		$sql .= " order by id desc limit " . $pageSize . " offset " . $start;
//        pae($sql);
		$res = $this->Cluster_model->getList($sql);
		if ($res === false) {
			$res = array();
		}
		$sql_total = "select count(id) as count from data_centers where 1=1";
		if (!empty($username)) {
			$sql_total .= " and  owner like '%{$username}%' ";
		}
		if (!empty($province)) {
			$sql_total .= " and province like '%{$province}%' ";
		}
		if (!empty($city)) {
			$sql_total .= " and  city like '%{$city}%' ";
		}
		$res_total = $this->Cluster_model->getList($sql_total);
		$data['code'] = 200;
		$data['list'] = $res;
		$data['total'] = $res_total ? (int)$res_total[0]['count'] : 0;
		print_r(json_encode($data));
	}

	public function addIDC()
	{
		//获取token
		$arr = apache_request_headers();//获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		$name = $string['name'];
		$user_name = $string['user_name'];
		$province = $string['province'];
		$city = $string['city'];

		$this->load->model('Cluster_model');
		$sql_update = "INSERT INTO data_centers(`name`,`owner`,`province`,`city`) values ('$name','$user_name','$province','$city');";
		//echo $sql_update;exit;
		$res_update = $this->Cluster_model->updateList($sql_update);
		if ($res_update == 1) {
			$data['code'] = 200;
			$data['message'] = '新增成功';
		} else {
			$data['code'] = 501;
			$data['message'] = '新增失败';
		}
		print_r(json_encode($data));
	}

	public function editIDC()
	{
		//获取token
		$arr = apache_request_headers();//获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		$name = $string['name'];
		$user_name = $string['user_name'];
		$province = $string['province'];
		$city = $string['city'];
		$id = $string['id'];

		$this->load->model('Cluster_model');
		//查是否绑定idc
		$sql = "select count(*) as count from server_nodes where  dc_id='$id'";
		$res = $this->Cluster_model->getList($sql);
		//print_r($res);exit;
		if($res[0]['count']==0){
			$sql_update = "update data_centers set province='$province',city='$city'  where  id='$id'";
			$res_update = $this->Cluster_model->updateList($sql_update);
			if ($res_update == 1) {
				$data['code'] = 200;
				$data['message'] = '编辑成功';
			} else {
				$data['code'] = 501;
				$data['message'] = '编辑失败';
			}
		}else{
			$data['code'] = 201;
		}
		print_r(json_encode($data));
	}

	public function deleteIDC()
	{
		//获取token
		$arr = apache_request_headers();//获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		$id = $string['id'];
		$user_name = $string['user_name'];

		$this->load->model('Cluster_model');
		$sql_update = "delete from data_centers where id='$id'";
		$res_update = $this->Cluster_model->updateList($sql_update);
		if ($res_update == 1) {
			$data['code'] = 200;
			$data['message'] = '删除成功';
		} else {
			$data['code'] = 501;
			$data['message'] = '删除失败';
		}
		print_r(json_encode($data));
	}
	public function findCityInfo()
	{
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		$this->load->model('Cluster_model');
		$sql = "select id,province,city from data_centers group by province,city";
		$res = $this->Cluster_model->getList($sql);
		$data['code'] = 200;
		$data['res'] = $res;
		print_r(json_encode($data));
	}
	public function ifHostaddr()
	{
		//获取token
		$arr = apache_request_headers();//获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		$string = json_decode(@file_get_contents('php://input'), true);
		$id = $string['id'];
		$this->load->model('Cluster_model');
		$sql = "select hostaddr from server_nodes where dc_id='$id' group by hostaddr";
		$res = $this->Cluster_model->getList($sql);
		if(!empty($res)) {
			$res_count=count($res);
		}else{
			$res_count=0;
		}
		$ip_arr='';
		if($res_count>0){
			foreach($res as $row){
				$ip_arr.=$row['hostaddr'].',';
			}
			$ips=substr($ip_arr,0,strlen($ip_arr)-1);
			$data['code'] = 301;
			$data['message'] = '该idc绑定有ip，请前往计算机管理中解除关系才能进行删除操作';
			print_r(json_encode($data));
		}else{
			$data['code'] = 200;
			$data['message'] = '未绑定有ip';
			print_r(json_encode($data));
		}
	}
	public function getIDCName()
	{
		//获取token
		$arr = apache_request_headers();//获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		$string = json_decode(@file_get_contents('php://input'), true);
		$id = $string['cluster_id'];
		$this->load->model('Cluster_model');
		$sql = "select hostaddr from shard_nodes where db_cluster_id='$id'  and status!='deleted' group by hostaddr";
		$res = $this->Cluster_model->getList($sql);
		$arr=array();
		if(!empty($res)) {
			foreach ($res as $k=>$v){
				$idc_name=$this->getStroIDCName($v['hostaddr']);
				if(!empty($idc_name)){
					$idc=array('id'=>$idc_name['id'],'name'=>$idc_name['name']);
					array_push($arr,$idc);
				}
			}
		}
		$data['code'] = 200;
		$data['list'] = $arr;
		$data['total'] = count($arr);
		print_r(json_encode($data));
	}
	public function getStroIDCName($ip)
	{
		$sql = "select d.name,d.id from server_nodes as s left  join data_centers as d on s.dc_id=d.id where s.machine_type is not null and s.machine_type='storage' and s.node_stats='running' and s.hostaddr='$ip'";
		$this->load->model('Cluster_model');
		$res = $this->Cluster_model->getList($sql);
		return $res[0];
	}
	public function idcSwitch()
	{
		//获取token
		$arr = apache_request_headers(); //获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		//判断参数
		$string = json_decode(@file_get_contents('php://input'), true);
		//调接口
		$this->load->model('Cluster_model');
		$post_data = str_replace("\\/", "/", json_encode($string));
		$post_arr = $this->Cluster_model->postData($post_data, $this->post_url);
		$post_arr = json_decode($post_arr, TRUE);
		$data = $post_arr;
		print_r(json_encode($data));
	}
	public function getIDCCity()
	{
		//获取token
		$arr = apache_request_headers();//获取请求头数组
		$token = $arr["Token"];
		if (empty($token)) {
			$data['code'] = 201;
			$data['message'] = 'token不能为空';
			print_r(json_encode($data));
			return;
		}
		$string = json_decode(@file_get_contents('php://input'), true);
		$id = $string['cluster_id'];
		$this->load->model('Login_model');
		$sql = "select idcs from cluster_type_info where db_cluster_id='$id' and cluster_type='idc' and status!='deleted' ";
		$res = $this->Login_model->getList($sql);
		$arr=array();
		if(!empty($res)) {
			foreach ($res as $row=>$value){
				if($value['idcs']){
					$string = json_decode($res[$row]['idcs'], true);
					if(!empty($string)){
						foreach ($string as $k => $v) {
							if($k=='citys'){
								foreach ($v as $k1 => $v1) {
									//print_r($v[$k1]);exit;
									$city = array('id' => $k1, 'name' => $v[$k1]);
									if (in_array($city, $arr)) {
										continue;
									} else {
										array_push($arr, $city);
									}
								}
							}
						}
					}
				}
			}
		}
		$data['code'] = 200;
		$data['list'] = $arr;
		$data['total'] = count($arr);
		print_r(json_encode($data));
	}
}

