<?php
defined('BASEPATH') or exit('No direct script access allowed');

class ProxyConfig extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getConfig()
    {
        log_message('debug', '=== getProxyConfig() Start ===');

        try {
            // 验证Token
            $token = $this->getRequestToken();
            $this->validateToken($token);

            // 获取代理配置
            $sql = "SELECT 
                    server_address, 
                    port, 
                    username, 
                    create_at, 
                    update_at 
                FROM cluster_alarm_proxy_config 
                LIMIT 1";

            $config = $this->Cluster_model->getList($sql);
            
            if ($config) {
                // 格式化时间戳
                $config[0]['create_at'] = date('Y-m-d H:i:s', $config[0]['create_at']);
                if (!empty($config[0]['update_at'])) {
                    $config[0]['update_at'] = date('Y-m-d H:i:s', $config[0]['update_at']);
                }
            }

            log_message('debug', '=== getProxyConfig() End ===');
            return $this->jsonResponse($config ? $config[0] : null);

        } catch (Exception $e) {
            log_message('error', 'Get proxy config failed: ' . $e->getMessage());
            return $this->errorResponse($e->getMessage());
        }
    }

    public function updateConfig()
    {
        log_message('debug', '=== updateProxyConfig() Start ===');

        try {
            // 验证Token
            $token = $this->getRequestToken();
            $this->validateToken($token);

            // 获取POST数据
            $post_data = $this->getPostData();
            log_message('debug', 'Post data: ' . json_encode($post_data));

            // 验证请求数据
            if (!$this->validateRequest('ProxyConfigValidator', 'validateUpdate', $post_data)) {
                return;
            }

            // 检查是否存在配置
            $checkSql = "SELECT id FROM cluster_alarm_proxy_config LIMIT 1";
            $existingConfig = $this->Cluster_model->getList($checkSql);

            $current_time = time();
            if (!empty($existingConfig)) {
                // 更新配置
                $sql = "UPDATE cluster_alarm_proxy_config SET 
                    server_address = ?, 
                    port = ?, 
                    username = ?, 
                    password = ?, 
                    update_at = ?";
                $params = [
                    $post_data['serverAddress'],
                    $post_data['port'],
                    $post_data['username'] ?? '',
                    $post_data['password'] ?? '',
                    $current_time
                ];
            } else {
                // 新增配置
                $sql = "INSERT INTO cluster_alarm_proxy_config 
                    (server_address, port, username, password, create_at) 
                    VALUES (?, ?, ?, ?, ?)";
                $params = [
                    $post_data['serverAddress'],
                    $post_data['port'],
                    $post_data['username'] ?? '',
                    $post_data['password'] ?? '',
                    $current_time
                ];
            }

            $result = $this->Cluster_model->updateList($sql, $params);
            if (!$result) {
                throw new Exception('配置更新失败');
            }

            return $this->jsonResponse([], 200, '代理服务器配置更新成功');

        } catch (Exception $e) {
            log_message('error', 'Update proxy config failed: ' . $e->getMessage());
            return $this->errorResponse($e->getMessage());
        }
    }

    public function testConnection()
    {
        log_message('debug', '=== testProxyConnection() Start ===');

        try {
            // 验证Token
            $token = $this->getRequestToken();
            $this->validateToken($token);

            // 获取POST数据
            $post_data = $this->getPostData();
            log_message('debug', 'Post data: ' . json_encode($post_data));

            // 验证请求数据
            if (!$this->validateRequest('ProxyConfigValidator', 'validateTest', $post_data)) {
                return;
            }

            // 测试连接
            $ch = curl_init();
            $options = [
                CURLOPT_URL => "http://{$post_data['serverAddress']}:{$post_data['port']}",
                CURLOPT_TIMEOUT => 5,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CONNECTTIMEOUT => 3,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => false
            ];

            // 添加认证信息
            if (!empty($post_data['username']) && !empty($post_data['password'])) {
                $options[CURLOPT_HTTPAUTH] = CURLAUTH_BASIC;
                $options[CURLOPT_USERPWD] = "{$post_data['username']}:{$post_data['password']}";
            }

            curl_setopt_array($ch, $options);
            $result = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);

            if ($httpCode >= 200 && $httpCode < 300) {
                log_message('debug', '=== testProxyConnection() End: Success ===');
                return $this->jsonResponse([], 200, '代理服务器连接成功');
            } else {
                throw new Exception('代理服务器连接失败: ' . ($error ?: "HTTP状态码 {$httpCode}"));
            }

        } catch (Exception $e) {
            log_message('error', 'Test proxy connection failed: ' . $e->getMessage());
            return $this->errorResponse($e->getMessage());
        }
    }
} 