<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AliyunSms {
    private $accessKeyId;
    private $accessKeySecret;
    private $signName;
    private $templateCode;
    private $endpoint = 'https://dysmsapi.aliyuncs.com';
    private $version = '2017-05-25';

    public function __construct()
    {
        // 构造函数
    }

    /**
     * 发送短信
     * @param string $accessKeyId 访问密钥ID
     * @param string $accessKeySecret 访问密钥密码
     * @param string $phoneNumber 手机号码
     * @param string $signName 短信签名
     * @param string $templateCode 短信模板ID
     * @param array $templateParam 模板参数
     * @return array
     */
    public function sendSms($accessKeyId, $accessKeySecret, $phoneNumber, $signName, $templateCode, $templateParam)
    {
        $params = array(
            'AccessKeyId' => $accessKeyId,
            'Action' => 'SendSms',
            'Format' => 'JSON',
            'PhoneNumbers' => $phoneNumber,
            'SignName' => $signName,
            'TemplateCode' => $templateCode,
            'TemplateParam' => json_encode($templateParam),
            'Timestamp' => gmdate('Y-m-d\TH:i:s\Z'),
            'Version' => $this->version,
            'SignatureMethod' => 'HMAC-SHA1',
            'SignatureVersion' => '1.0',
            'SignatureNonce' => uniqid()
        );

        // 签名
        $params['Signature'] = $this->sign($params, $accessKeySecret);

        // 发送请求
        $url = $this->endpoint . '/?' . http_build_query($params);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

    /**
     * 生成签名
     */
    private function sign($params, $accessKeySecret)
    {
        ksort($params);
        $query = '';
        foreach ($params as $key => $value) {
            $query .= '&' . $this->percentEncode($key) . '=' . $this->percentEncode($value);
        }
        $stringToSign = 'GET&%2F&' . $this->percentEncode(substr($query, 1));
        return base64_encode(hash_hmac('sha1', $stringToSign, $accessKeySecret . '&', true));
    }

    /**
     * URL编码
     */
    private function percentEncode($str)
    {
        $res = urlencode($str);
        $res = preg_replace('/\+/', '%20', $res);
        $res = preg_replace('/\*/', '%2A', $res);
        $res = preg_replace('/%7E/', '~', $res);
        return $res;
    }
} 