<?php

class Cdc_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->db = $this->load->database('default', true);
        $this->config->load('myconfig');
        $this->pg_database = $this->config->item('pg_database');
        $this->pg_username = $this->config->item('pg_username');
        $this->default_username = $this->config->item('default_username');
        $this->post_url = $this->config->item('post_url');
        $this->grafana_key = $this->config->item('grafana_key');
    }


	/**
	 * @throws Exception
	 */
	public function add_cdc_worker_list($group_name, $params,$is_straeming=false)
    {

        $master_sql = "select * from cluster_cdc_server where group_name=?";
        $masterList = $this->getList($master_sql, [$group_name]);

        if ($masterList) {

            $dump_db_type = $params['paras']['dump_db_type'];
            
            // 检查是否已存在相同的任务
            $check_sql = "SELECT * FROM cluster_cdc_worker WHERE group_name = ? AND delete_time IS NULL AND job_name IS NOT NULL";
            log_message('debug', '检查是否存在重复的CDC任务，执行SQL: ' . $check_sql . '，参数: ' . $group_name);
            $existing_tasks = $this->getList($check_sql, [$group_name]);
            
            log_message('debug', '找到现有任务数量: ' . ($existing_tasks ? count($existing_tasks) : 0));

            if ($existing_tasks  && !$is_straeming) {
                foreach ($existing_tasks as $task) {
                    // 检查worker_param是否为空或无效的JSON
                    if (($task['worker_param'])=="") {
                        log_message('debug', '任务ID: ' . $task['id'] . ' worker_param为空，将其标记为删除状态');
                        // worker_param为空，将任务标记为删除状态
                        $update_sql = "UPDATE cluster_cdc_worker SET delete_time = ? WHERE id = ?";
                        $this->updateList($update_sql, [time(), $task['id']]);
                        continue;
                    }
                    
                    $task_params = json_decode($task['worker_param'], true);

            
                    // 如果JSON解析失败，也标记为删除状态
                    if ($task_params === null) {
                        log_message('debug', '任务ID: ' . $task['id'] . ' worker_param JSON解析失败，将其标记为删除状态');
                        $update_sql = "UPDATE cluster_cdc_worker SET delete_time = ? WHERE id = ?";
                        $this->updateList($update_sql, [time(), $task['id']]);
                        continue;
                    }
             
                    
                    // 仅当任务未被删除时进行检查
                    if (isset($task_params['dump_db_type']) &&
                        isset($task_params['dump_tables']) && 
                        isset($task_params['output_plugins'][0]['plugin_name'])) {
                        
                        // 记录现有任务的关键参数
                        log_message('debug', '现有任务参数 - dump_db_type: ' . $task_params['dump_db_type'] . 
                                           ', dump_tables: ' . json_encode($task_params['dump_tables']) . 
                                           ', plugin_name: ' . $task_params['output_plugins'][0]['plugin_name']);
                        
                        // 记录新任务的关键参数
                        log_message('debug', '新任务参数 - dump_db_type: ' . $params['paras']['dump_db_type'] . 
                                           ', dump_tables: ' . json_encode($params['paras']['dump_tables']) . 
                                           ', plugin_name: ' . $params['paras']['output_plugins'][0]['plugin_name']);
                        
                        // 检查三个关键参数是否相同
                        if ($task_params['dump_tables'] == $params['paras']['dump_tables'] &&
                            $task_params['output_plugins'][0]['plugin_name'] == $params['paras']['output_plugins'][0]['plugin_name']) {
                            
                            log_message('debug', '发现重复任务! 任务ID: ' . $task['id'] . ' 与新提交的任务参数完全匹配');
                            // 任务已存在，返回错误信息
                            $data['code'] = 201;
                            $data['message'] = '任务已存在，不能重复添加相同的CDC任务';
                            return $data;
                        } else {
                            log_message('debug', '任务ID: ' . $task['id'] . ' 与新任务不匹配，继续检查下一个任务');
                        }
                    } else {
                        log_message('debug', '任务ID: ' . $task['id'] . ' worker_param格式不正确或缺少必要参数，将其标记为删除状态');
                        // 如果worker_param格式不正确或缺少必要参数，也标记为删除状态
                        $update_sql = "UPDATE cluster_cdc_worker SET delete_time = ? WHERE id = ?";
                        $this->updateList($update_sql, [time(), $task['id']]);
                    }
                }
            }
            
            log_message('debug', '未找到重复任务，准备添加新任务');
            
            if ($dump_db_type == 'kunlunbase' && $params['paras']['output_plugins'][0]['plugin_name'] == 'event_mongodb') {
                $params['paras']['hex_blob'] = "0";
                $params['paras']['skip_escape_str'] = "1";
            }


            if ($dump_db_type == 'kunlunbase' && $params['paras']['output_plugins'][0]['plugin_name'] == 'event_es') {
                $params['paras']['hex_blob'] = "0";
                $params['paras']['skip_escape_str'] = "1";
            }

            $curl_addr = "http://" . trim($masterList[0]['host_addr']) . ":" . trim($masterList[0]['port']) . "/kunlun_cdc";

            log_message('debug', '=== add_cdc_worker_list 准备发送请求 ===');
            log_message('debug', 'curl_addr: ' . $curl_addr);
            log_message('debug', '发送的参数: ' . json_encode($params));

            $response = $this->GetCurlData($curl_addr, $params);
            
            log_message('debug', '=== GetCurlData 返回结果 ===');
            log_message('debug', 'response原始数据: ' . ($response ? $response : 'NULL'));
            
            if ($response) {
                $responseArr = json_decode($response, true);
                
                log_message('debug', '=== JSON解析结果 ===');
                if (json_last_error() !== JSON_ERROR_NONE) {
                    log_message('error', 'JSON解析失败: ' . json_last_error_msg());
                    log_message('error', '原始响应数据: ' . $response);
                    return null;
                }
                
                log_message('debug', '解析后的responseArr: ' . json_encode($responseArr));
                log_message('debug', 'responseArr类型: ' . gettype($responseArr));
                
                if (is_array($responseArr)) {
                    log_message('debug', 'responseArr键列表: ' . json_encode(array_keys($responseArr)));
                    
                    if (isset($responseArr['status'])) {
                        log_message('debug', 'status字段值: ' . $responseArr['status']);
                    } else {
                        log_message('error', 'responseArr中缺少status字段!');
                    }
                    
                    if (isset($responseArr['job_id'])) {
                        log_message('debug', 'job_id字段值: ' . $responseArr['job_id']);
                        log_message('debug', 'job_id类型: ' . gettype($responseArr['job_id']));
                    } else {
                        log_message('error', 'responseArr中缺少job_id字段!');
                    }
                } else {
                    log_message('error', 'responseArr不是数组类型!');
                }
                
                if ($responseArr['status'] == 'Fail') {
                    log_message('debug', '=== CDC请求失败 ===');
                    log_message('debug', 'error_info: ' . (isset($responseArr['error_info']) ? $responseArr['error_info'] : '未知错误'));
                    
                    $data['code'] = 201;
                    $data['message'] = $responseArr['error_info'];
                } else {
                    log_message('debug', '=== CDC请求成功 ===');
                    
                    $data['code'] = 200;
                    $data['list'] = $responseArr;
                    $data['job_id'] = $responseArr['job_id'];
                    $data['message'] = '添加成功';
                    
                    log_message('debug', '构造的返回数据: ' . json_encode($data));
                    log_message('debug', '返回数据中的job_id: ' . (isset($data['job_id']) ? $data['job_id'] : 'NULL'));
                }
                
                //新增记录
                $status = $responseArr['status'] == 'Fail' ? 'failed' : 'done';
                log_message('debug', '记录状态: ' . $status);

                $parms = [
                    $responseArr['job_id'],
                    NULL,
                    'add_cdc_worker_list',
                    $status,
                    $response,
                    date("Y-m-d H:i:s", time()),
                    date("Y-m-d H:i:s", time()),
                    json_encode($params),
                    ''
                ];
                
                log_message('debug', '准备记录日志，参数: ' . json_encode($parms));
                $this->cluster_general_job_log($parms);

                log_message('debug', '=== add_cdc_worker_list 即将返回数据 ===');
                log_message('debug', '最终返回的data: ' . json_encode($data));
                
                return $data;
            } else {
                log_message('error', '=== GetCurlData 返回空响应 ===');
                log_message('error', 'curl_addr: ' . $curl_addr);
                log_message('error', '发送参数: ' . json_encode($params));
            }
        } else {
            log_message('error', '=== CDC Group不存在 ===');
            log_message('error', 'group_name: ' . $group_name);
            log_message('error', '查询SQL: ' . $master_sql);
            log_message('error', 'masterList结果: ' . json_encode($masterList));
        }
        
        log_message('debug', '=== add_cdc_worker_list 返回NULL ===');
        return null;
    }


    public function get_cdc_worker_state($group_name, $job_id)
    {
        // 尝试从缓存读取数据
        $cached_data = $this->_get_cdc_worker_state_cache($group_name, $job_id);
        if ($cached_data !== null) {
            return $cached_data;
        }

        $master_sql = "select * from cluster_cdc_server where group_name=?";
        $masterList = $this->getList($master_sql, [$group_name]);
        $resp = [];
        if ($masterList) {
            $curlData = [
                "version" => "1.0",
                "job_id" => $job_id,
                "job_type" => "get_state",
                "timestamp" => time(),
                "user_name" => "kunlun_test"
            ];

            $curl_addr = "http://" . trim($masterList[0]['host_addr']) . ":" . trim($masterList[0]['port']) . "/kunlun_cdc";

            $response = $this->GetCurlData($curl_addr, $curlData);
            $responseArr = json_decode($response, true);

            if (isset($responseArr['attachment']['job_state']) && $responseArr['attachment']['job_state'] == "fail") {
                $resp = [
                    'code' => 201,
                    'status' => 'failed',
                    'message' => 'error code ' . (isset($responseArr['attachment']['err_code']) ? $responseArr['attachment']['err_code'] : 'unknown') . ' message:' . (isset($responseArr['attachment']['err_msg']) ? $responseArr['attachment']['err_msg'] : 'unknown error'),
                    'data' => $responseArr,
                ];

                $updata_sql = "update cluster_general_job_log set `memo`=?,`status`=? where `job_type`=? and `job_id`=?";
                $this->updateList(
                    $updata_sql,
                    [
                        json_encode($resp),
                        "failed",
                        'add_cdc_worker_list',
                        $job_id
                    ]
                );
            } else {
                $resp = [
                    'code' => 200,
                    'status' => 'done',
                    'message' => $responseArr,
                    'data' => $responseArr,
                ];
            }
        }
        
        // 保存到缓存
        if (!empty($resp)) {
            $this->_save_cdc_worker_state_cache($group_name, $job_id, $resp);
        }
        
        return $resp;
    }

    /**
     * 从缓存获取CDC worker状态
     */
    private function _get_cdc_worker_state_cache($group_name, $job_id)
    {
        try {
            // 检查必要的参数
            if (empty($group_name) || empty($job_id)) {
                return null;
            }

            // 生成安全的缓存键和路径
            $cache_key = md5("cdc_worker_state_" . $group_name . "_" . $job_id);
            
            // 确定缓存目录，使用系统临时目录作为fallback
            $cache_base_dir = defined('FCPATH') ? FCPATH : sys_get_temp_dir();
            $cache_dir = $cache_base_dir . '/cache/cdc_worker_state';
            $cache_file = $cache_dir . '/' . $cache_key . '.json';
            
            // 检查缓存文件是否存在且未过期
            if (!file_exists($cache_file)) {
                return null;
            }
            
            // 检查文件修改时间（1分钟缓存）
            if ((time() - filemtime($cache_file)) >= 60) {
                // 缓存过期，尝试删除旧文件
                if (is_writable($cache_file)) {
                    unlink($cache_file);
                }
                return null;
            }
            
            // 读取缓存内容
            $cached_content = file_get_contents($cache_file);
            if ($cached_content === false) {
                return null;
            }
            
            // 解析JSON数据
            $cached_data = json_decode($cached_content, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                // JSON解析失败，删除损坏的缓存文件
                if (is_writable($cache_file)) {
                    unlink($cache_file);
                }
                return null;
            }
            
            return $cached_data;
            
        } catch (Exception $e) {
            // 缓存读取失败，记录错误但不影响主流程
            log_message('error', 'CDC worker state cache read failed: ' . $e->getMessage());
            return null;
        }
    }

    /**
     * 保存CDC worker状态到缓存
     */
    private function _save_cdc_worker_state_cache($group_name, $job_id, $data)
    {
        try {
            // 检查必要的参数
            if (empty($group_name) || empty($job_id) || empty($data)) {
                return false;
            }

            // 生成安全的缓存键和路径
            $cache_key = md5("cdc_worker_state_" . $group_name . "_" . $job_id);
            
            // 确定缓存目录
            $cache_base_dir = defined('FCPATH') ? FCPATH : sys_get_temp_dir();
            $cache_dir = $cache_base_dir . '/cache/cdc_worker_state';
            $cache_file = $cache_dir . '/' . $cache_key . '.json';
            
            // 创建缓存目录
            if (!is_dir($cache_dir)) {
                if (!mkdir($cache_dir, 0755, true)) {
                    log_message('error', 'Failed to create cache directory: ' . $cache_dir);
                    return false;
                }
            }
            
            // 检查目录是否可写
            if (!is_writable($cache_dir)) {
                log_message('error', 'Cache directory is not writable: ' . $cache_dir);
                return false;
            }
            
            // 序列化数据
            $json_data = json_encode($data);
            if (json_last_error() !== JSON_ERROR_NONE) {
                log_message('error', 'Failed to encode cache data: ' . json_last_error_msg());
                return false;
            }
            
            // 写入缓存文件
            $result = file_put_contents($cache_file, $json_data, LOCK_EX);
            if ($result === false) {
                log_message('error', 'Failed to write cache file: ' . $cache_file);
                return false;
            }
            
            return true;
            
        } catch (Exception $e) {
            // 缓存写入失败，记录错误但不影响主流程
            log_message('error', 'CDC worker state cache write failed: ' . $e->getMessage());
            return false;
        }
    }


    public function cluster_general_job_log($params)
    {
        $cluster_general_job_log_sql = "INSERT INTO `cluster_general_job_log` ( `job_id`, `related_id`, `job_type`, `status`, `memo`, `when_started`, `when_ended`, `job_info`, `user_name`) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $this->updateList($cluster_general_job_log_sql, $params);
    }


    public function delete_cdc_worker_task($job_id, $cdc_group, $delete_params)
    {

        $cdc_group_sql = "select * from cluster_cdc_server where group_name=? and `master`=1";
        $cdc_serverList = $this->getList($cdc_group_sql, [$cdc_group]);
        // pae([$job_id, $cdc_group, $delete_params, $cdc_serverList]);
        if ($cdc_serverList) {
            $curl_addr = "http://" . trim($cdc_serverList[0]['host_addr']) . ":" . trim($cdc_serverList[0]['port']) . "/kunlun_cdc";
            $response = $this->GetCurlData($curl_addr, $delete_params);
            $responseArr = json_decode($response, true);
            if ($responseArr) {
                $delete_sql = "update  cluster_cdc_worker  set `delete_time`=? where job_id=?";
                $this->updateList($delete_sql, [time(), $job_id]);
                $status = 'done';
            } else {
                $status = 'failed';
            }
            $params = [
                '',
                '',
                'delete_cdc_worker',
                $status,
                $response,
                date("Y-m-d H:i:s", time()),
                date("Y-m-d H:i:s", time()),
                json_encode($delete_params),
                ''
            ];

            $this->cluster_general_job_log($params);
            return $responseArr;
        } else {

            $delete_sql = "update  cluster_cdc_worker  set `delete_time`=? where job_id=?";
            $this->updateList($delete_sql, [time(), $job_id]);
            $params = [
                '',
                '',
                'delete_cdc_worker',
                'failed',
                'delete_cdc_worker_error',
                date("Y-m-d H:i:s", time()),
                date("Y-m-d H:i:s", time()),
                json_encode($delete_params),
                ''
            ];
            $this->cluster_general_job_log($params);
            return null;
        }
    }

    //查询数据
    public function getList($sql, $params = [])
    {
        try {
            // 执行带参数的 SQL 语句
            $q = $this->db->query($sql, $params);
            if ($q && $q->num_rows() > 0) {
                return $q->result_array();
            } else {
                return false;
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    public function updateList($sql, $params = [])
    {
        try {
            // 执行带参数的 SQL 语句
            $query = $this->db->query($sql, $params);
            if ($query === false) {
                // 记录错误并返回错误信息
                return $this->db->error();
            }
            return $this->db->affected_rows();
        } catch (Exception $e) {
            // 处理异常并返回错误代码
            return [
                'code' => 500,
                'error' => $e->getMessage()
            ];
        }
    }


    public function GetCurlData($http, $post)
    {
        // 先获取一下主
        $curlData = [
            "version" => "1.0",
            "job_id" => "",
            "job_type" => "get_leader",
            "timestamp" => time(),
            "user_name" => "kunlun_test"
        ];

        log_message('debug', '开始执行GetCurlData方法');
        log_message('debug', '初始化curl，URL: ' . $http);
        log_message('debug', '发送的数据: ' . json_encode($curlData));

        // 初始化第一个请求
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $http,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($curlData),
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                ),
            )
        );

        // 执行curl请求
        $rs = curl_exec($curl);
        if (!$rs) {
            $curlError = curl_error($curl);
            log_message('error', '第一次curl请求失败: ' . $curlError);
            return false;
        }
        log_message('debug', '第一次curl请求成功，返回数据: ' . $rs);

        // 解析返回数据
        $rsArr = json_decode($rs, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            log_message('error', 'JSON解析错误: ' . json_last_error_msg());
            return false;
        }

        log_message('debug', '解析后的返回数据: ' . print_r($rsArr, true));

        // 获取第二个请求的URL
        if (!isset($rsArr['attachment']['ipPort'])) {
            log_message('error', '返回数据中缺少ipPort字段');
            return false;
        }

        $https = "http://" . $rsArr['attachment']['ipPort'] . '/kunlun_cdc';
        log_message('debug', '构建第二个请求的URL: ' . $https);

        // 初始化第二个curl请求
        $curl = curl_init();
        curl_setopt_array(
            $curl,
            array(
                CURLOPT_URL => $https,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($post),
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                ),
            )
        );

        log_message('debug', '发送第二个请求的数据: ' . json_encode($post));

        // 执行第二个curl请求
        $secondRs = curl_exec($curl);
        if (!$secondRs) {
            $curlError = curl_error($curl);
            log_message('error', '第二次curl请求失败: ' . $curlError);
            return false;
        }

        log_message('debug', '第二次curl请求成功，返回数据: ' . $secondRs);

        return $secondRs;
    }



    public function getMysqlNullDb($host, $port, $username, $pwd, $dbname, $sql)
    {
        mysqli_report(MYSQLI_REPORT_STRICT);
        try {
            // 连接数据库服务器（不指定数据库）
            $conn = mysqli_connect("{$host}:{$port}", $username, $pwd);

            // 检查连接是否成功
            if (!$conn) {
                $arr['code'] = 500;
                $arr['message'] = 'Connection failed: ' . mysqli_connect_error();
                $params = [
                    '',
                    '',
                    'cdc_auto_create_db_connect',
                    'err',
                    json_encode($arr),
                    date("Y-m-d H:i:s", time()),
                    date("Y-m-d H:i:s", time()),
                    json_encode($arr),
                    ''
                ];

                $this->cluster_general_job_log($params);
                return $arr;
            }

            // 尝试选择数据库
            if (!mysqli_select_db($conn, $dbname)) {
                // 如果数据库不存在，则创建数据库
                $createDbSql = "CREATE DATABASE $dbname";
                if (mysqli_query($conn, $createDbSql)) {
                    $arr['message'] = 'Database created successfully';
                } else {
                    $arr['code'] = 500;
                    $arr['message'] = 'Database creation failed: ' . mysqli_error($conn);
                    mysqli_close($conn);
                    $params = [
                        '',
                        '',
                        'cdc_auto_create_db',
                        'err',
                        json_encode($arr),
                        date("Y-m-d H:i:s", time()),
                        date("Y-m-d H:i:s", time()),
                        json_encode($arr),
                        ''
                    ];

                    $this->cluster_general_job_log($params);
                    return $arr;
                }

                // 再次选择新创建的数据库
                if (!mysqli_select_db($conn, $dbname)) {
                    $arr['code'] = 500;
                    $arr['message'] = 'Database selection failed after creation: ' . mysqli_error($conn);
                    mysqli_close($conn);
                    $params = [
                        '',
                        '',
                        'cdc_auto_create_table',
                        'err',
                        json_encode($arr),
                        date("Y-m-d H:i:s", time()),
                        date("Y-m-d H:i:s", time()),
                        json_encode($arr),
                        ''
                    ];

                    $this->cluster_general_job_log($params);
                    return $arr;
                }
            }

            // 执行插入操作
            if (mysqli_query($conn, $sql)) {
                $arr['code'] = 200;
                $arr['message'] = 'Record inserted successfully';
            } else {
                $arr['code'] = 500;
                $arr['message'] = 'Insert failed: ' . mysqli_error($conn);
            }
            $params = [
                '',
                '',
                'cdc_auto_create_db_connect',
                'err',
                json_encode($arr),
                date("Y-m-d H:i:s", time()),
                date("Y-m-d H:i:s", time()),
                json_encode($arr),
                ''
            ];

            $this->cluster_general_job_log($params);

            // 关闭连接
            mysqli_close($conn);
            return $arr;
        } catch (Exception $e) {
            // 捕获异常
            $arr['message'] = iconv('gbk', 'utf-8', $e->getMessage());
            $arr['code'] = 500;
            $params = [
                '',
                '',
                'cdc_auto_create_db_connect',
                'err',
                json_encode($arr),
                date("Y-m-d H:i:s", time()),
                date("Y-m-d H:i:s", time()),
                json_encode($arr),
                ''
            ];

            $this->cluster_general_job_log($params);
            return $arr;
        }
    }
}
