<?php

require FCPATH . 'vendor/autoload.php'; // 加载 Composer 自动加载器

use MongoDB\Client;


class MongoDB_model extends CI_Model
{
    private Client $client;


    public function __construct()
    {
        parent::__construct();

    }


    public function get_db_list($db_url): array
    {
       

        $client = new Client("mongodb://" . $db_url);
        
        // 获取所有数据库
        $databases = $client->listDatabases();
        
        //获取系统以外全部的collection以及collection的第一条ObjectId
        $res = [];
        
        // 遍历所有数据库
        foreach ($databases as $db) {
            $db_name = $db->getName();
            
            // 排除系统数据库（admin、local、config等）
            if (in_array($db_name, ['admin', 'local', 'config'])) {
                continue;
            }
            
            $database = $client->selectDatabase($db_name);
            $collections = $database->listCollections();
            
            // 遍历数据库中的所有集合
            foreach ($collections as $collection) {
                $collectionName = $collection->getName();
                
                // 排除系统集合（通常以下划线开头）
                if (strpos($collectionName, '_') === 0) {
                    continue;
                }
                
                $currentCollection = $database->selectCollection($collectionName);
                $document = $currentCollection->findOne([], [
                    'sort' => ['_id' => 1]  // 1 表示按 ObjectId 升序排序
                ]);

                $objectId = "";
                if ($document !== null) {
                    $objectId = $document->_id->__toString();
                }

                $res[] = [
                    'binlog_file' => $db_name,
                    'binlog_pos' => $collectionName,
                    'gtid_set' => $objectId,
                ];
            }
        }
        
        
        return $res;
    }



    public function get_db_list_max_id($db_url, $db_name): array
    {
        $client = new Client("mongodb://" . $db_url);

        $database = $client->selectDatabase($db_name);

        $collections = $database->listCollections();

        //pa($collections);

        $res = [];
        foreach ($collections as $collection) {
            $collectionName = $collection->getName();
            $currentCollection = $database->selectCollection($collectionName);

            // 获取集合中最大的 _id
            $document = $currentCollection->findOne([], [
                'sort' => ['_id' => -1]  // -1 表示按 ObjectId 降序排序，获取最大值
            ]);

            $objectId = "";
            if ($document !== null) {
                $objectId = $document->_id->__toString();
            }


            $res[] = [
                'binlog_file' => $db_name,
                'binlog_pos' => $collection->getName(),
                'gtid_set' => $objectId,
            ];
        }

        return $res;
    }



    public function get_collection_list($db_name): \MongoDB\Model\CollectionInfoIterator
    {
        return $this->client->$db_name->listCollections();
    }



    public function del_db_list($db_url, $db_name, $collection_name): array
    {

        $client = new Client("mongodb://" . $db_url);

        $database_exists = false;
        foreach ($client->listDatabases() as $db) {
            if ($db->getName() === $db_name) {
                $database_exists = true;
                break;
            }
        }

        $database = $client->selectDatabase($db_name);

        $collection_exists = false;
        if ($database_exists) {
            foreach ($database->listCollections() as $collection) {
                if ($collection->getName() === $collection_name) {
                    $collection_exists = true;
                    break;
                }
            }
        }

        $currentCollection = $database->selectCollection($collection_name);
        if ($collection_exists) {
            $currentCollection->deleteMany([]);
        } else {
            $database->createCollection($collection_name);
        }

//        $collections = $database->listCollections();



        $res = [];
//        foreach ($collections as $collection) {
//            $collectionName = $collection->getName();
//            $currentCollection = $database->selectCollection($collectionName);
//            $document = $currentCollection->findOne([], [
//                'sort' => ['_id' => 1]
//            ]);
//
//            $objectId = "";
//            if ($document !== null) {
//                $objectId = $document->_id->__toString();
//            }
//
//            $res[] = [
//                'binlog_file' => $db_name,
//                'binlog_pos' => $collectionName,
//                'gtid_set' => $objectId,
//            ];
//        }

//        pae($collections);

        return $res;
    }


}


