<?php

class Stream_recover_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->db = $this->load->database('default', true);
        $this->config->load('myconfig');
        $this->pg_database = $this->config->item('pg_database');
        $this->pg_username = $this->config->item('pg_username');
        $this->default_username = $this->config->item('default_username');
        $this->post_url = $this->config->item('post_url');
        $this->grafana_key = $this->config->item('grafana_key');
        $sql = "SHOW TABLES LIKE 'cluster_steams_recover'";

    }

    // 获取 cluster_steam_task 表中的记录


    //查询数据
    public function getList($sql, $params = [])
    {
        try {
            // 执行带参数的 SQL 语句
            $q = $this->db->query($sql, $params);
            if ($q && $q->num_rows() > 0) {
                return $q->result_array();
            } else {
                return false;
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());

        }
    }



    public function updateList($sql, $params = [])
    {
        try {


            // 执行带参数的 SQL 语句
            $query = $this->db->query($sql, $params);


            if ($query === false) {
                // 记录错误并返回错误信息
                return [
                    'code' => 500,
                    'error' => $this->db->error()

                ];
            }
            return [
                'code' => 200,
                'msg' =>  $this->db->error(),
                'data' => [
                    'affected_rows' => $this->db->affected_rows()
                ]
            ];
        } catch (Exception $e) {
            // 处理异常并返回错误代码
            return [
                'code' => 500,
                'error' => $e->getMessage()
            ];
        }
    }

}

