-- 创建告警推送历史表
CREATE TABLE IF NOT EXISTS `kunlun_alarm_push_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `alarm_id` int(11) NOT NULL COMMENT '告警ID',
  `push_type` varchar(20) NOT NULL COMMENT '推送类型：phone_message, mail, wechat, proxy',
  `receiver` varchar(255) NOT NULL COMMENT '接收者',
  `content` text NOT NULL COMMENT '推送内容',
  `status` varchar(20) NOT NULL DEFAULT 'pending' COMMENT '推送状态：pending, success, failed',
  `push_time` datetime NOT NULL COMMENT '推送时间',
  `error_message` text COMMENT '错误信息',
  `is_manual` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否手动推送：0-自动，1-手动',
  PRIMARY KEY (`id`),
  KEY `idx_alarm_id` (`alarm_id`),
  KEY `idx_push_time` (`push_time`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='告警推送历史记录表'; 