package database

// SourceInfo 表示 source_data_info 中的 src_info 和 dest_info
type SourceInfo struct {
	ID          string `json:"id"`
	UserID      string `json:"user_id"`
	Name        string `json:"name"`
	RcrMeta     string `json:"rcr_meta"`
	DbType      string `json:"db_type"`
	WhenCreated string `json:"when_created"`
	UpdateTime  string `json:"update_time"`
}

// SourceDataInfo 表示 source_data_info 字段
type SourceDataInfo struct {
	Src      string     `json:"src"`
	SrcInfo  SourceInfo `json:"src_info"`
	Dest     string     `json:"dest"`
	DestInfo SourceInfo `json:"dest_info"`
	DbType   string     `json:"db_type"`
	TaskID   string     `json:"task_id"`
	Status   string     `json:"status"`
}

// RcrInfo 表示 rcr_info 字段
type RcrInfo struct {
	MainCluster  string `json:"main_cluster"`
	SlaveCluster string `json:"slave_cluster"`
	TaskID       string `json:"task_id"`
	Status       string `json:"status"`
}

// CdcInfo 表示 cdc_info 字段
type CdcInfo struct {
	ClusterServer string `json:"cluster_server"`
	ExportType    string `json:"export_type"`
	DbType        string `json:"db_type"`
	TaskID        string `json:"task_id"`
	Status        string `json:"status"`
}

// ClusterSteamTask 表示整个任务数据结构
type ClusterSteamTask struct {
	ID             int    `gorm:"primaryKey" json:"id"`
	SourceDataInfo string `gorm:"type:json" json:"source_data_info"`
	RcrInfo        string `gorm:"type:json" json:"rcr_info"`
	CdcInfo        string `gorm:"type:json" json:"cdc_info"`
	Status         int    `json:"status"`
	CreateAt       int    `json:"create_at"`
	UpdateAt       int    `json:"update_at"`
	TaskID         string `json:"task_id"`
	TaskName       string `json:"task_name"`
}
